/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final Object value;
    private final int offset;
    private final int count;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.offset = 0;
        this.count = 0;
        this.value = new char[0];
    }

    public String(String string) {
        Object object;
        int n = string.count;
        Object object2 = string.value;
        int n2 = StringValue.array_length(object2);
        if (n2 > n) {
            int n3 = string.offset;
            boolean bl = StringValue.is_byte_array(object2);
            object = bl ? Arrays.copyOfRange((byte[])object2, n3, n3 + n) : (byte[])Arrays.copyOfRange((char[])object2, n3, n3 + n);
        } else {
            object = object2;
        }
        this.offset = 0;
        this.count = n;
        this.value = object;
    }

    public String(char[] cArray) {
        this.offset = 0;
        this.count = cArray.length;
        this.value = StringValue.from(cArray);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.offset = 0;
        this.count = n2;
        this.value = StringValue.genValue(cArray, n, n + n2);
    }

    String(Object object, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = StringValue.array_length(object);
        if (n > n3 - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.offset = 0;
        this.count = n2;
        this.value = StringValue.genValue(object, n, n + n2);
    }

    public String(int[] nArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > nArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        int n3 = 0;
        int n4 = 1;
        char[] cArray = new char[n2 + n4];
        int n5 = n;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            if ((n7 = nArray[n5++]) < 0) {
                throw new IllegalArgumentException();
            }
            if (n4 <= 0 && n6 + 1 >= cArray.length) {
                if (n3 == 0) {
                    n3 = ((-n4 + 1) * n2 << 10) / i;
                    if ((n3 >>= 10) <= 0) {
                        n3 = 1;
                    }
                } else {
                    n3 *= 2;
                }
                int n8 = Math.min(cArray.length + n3, n2 * 2);
                n4 = n8 - cArray.length - (n2 - i);
                cArray = Arrays.copyOf(cArray, n8);
            }
            if (n7 < 65536) {
                cArray[n6++] = (char)n7;
                continue;
            }
            if (n7 <= 0x10FFFF) {
                Character.toSurrogates(n7, cArray, n6);
                n6 += 2;
                --n4;
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.offset = 0;
        this.value = cArray;
        this.count = n6;
    }

    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        String.checkBounds(byArray, n2, n3);
        char[] cArray = new char[n3];
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            n <<= 8;
            int n5 = n3;
            while (n5-- > 0) {
                cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
            }
        }
        this.offset = 0;
        this.count = n3;
        this.value = cArray;
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    private static void checkBounds(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > byArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((String)string, (byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((Charset)charset, (byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2) {
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public String(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    public String(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    private String(int n, int n2, Object object) {
        this.value = object;
        this.offset = n;
        this.count = n2;
    }

    private static char charAt(Object object, int n) {
        return StringValue.is_byte_array(object) ? (char)((byte[])object)[n] : ((char[])object)[n];
    }

    private static void setCharAt(Object object, int n, char c) {
        if (StringValue.is_byte_array(object)) {
            ((byte[])object)[n] = (byte)c;
        } else {
            ((char[])object)[n] = c;
        }
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return String.charAt(this.value, n + this.offset);
    }

    public int codePointAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointAtImpl(cArray, this.offset + n, this.offset + this.count);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointBeforeImpl(cArray, this.offset + n, this.offset);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointCountImpl(cArray, this.offset + n, n2 - n);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.offsetByCodePointsImpl(cArray, this.offset, this.count, this.offset + n, n2) - this.offset;
    }

    void getChars(char[] cArray, int n) {
        StringValue.copyValue(this.value, this.offset, cArray, n, this.count);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        StringValue.copyValue(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    void copyChars(int n, int n2, char[] cArray, int n3) {
        StringValue.checkBounds(this.count, n, n2);
        StringValue.copyChars(this.value, this.offset + n, cArray, n3, n2);
    }

    int copyBytes(int n, int n2, byte[] byArray, int n3) {
        StringValue.checkBounds(this.count, n, n2);
        return StringValue.copyBytes(this.value, this.offset + n, byArray, n3, n2);
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = this.offset + n2;
        int n6 = this.offset + n;
        char[] cArray = StringValue.inflateValue(this.value);
        while (n6 < n5) {
            byArray[n4++] = (byte)cArray[n6++];
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return StringCoding.encode((String)string, (char[])cArray, (int)this.offset, (int)this.count);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return StringCoding.encode((Charset)charset, (char[])cArray, (int)this.offset, (int)this.count);
    }

    public byte[] getBytes() {
        char[] cArray = StringValue.inflateValue(this.value);
        return StringCoding.encode((char[])cArray, (int)this.offset, (int)this.count);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = this.count;
            if (n == string.count) {
                if (StringValue.is_byte_array(this.value) && StringValue.is_byte_array(string.value)) {
                    return this.equalsCC(string);
                }
                return this.equalsX(string);
            }
        }
        return false;
    }

    private boolean equalsX(String string) {
        int n = this.count;
        Object object = this.value;
        Object object2 = string.value;
        int n2 = this.offset;
        int n3 = string.offset;
        boolean bl = StringValue.is_byte_array(object);
        boolean bl2 = StringValue.is_byte_array(object2);
        while (n-- != 0) {
            char c = bl ? (char)((byte[])object)[n2] : ((char[])object)[n2];
            char c2 = bl2 ? (char)((byte[])object2)[n3] : ((char[])object2)[n3];
            ++n2;
            ++n3;
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    private boolean equalsCC(String string) {
        int n = this.count;
        byte[] byArray = (byte[])this.value;
        byte[] byArray2 = (byte[])string.value;
        int n2 = this.offset;
        int n3 = string.offset;
        while (n-- != 0) {
            if (byArray[n2++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return this.contentEquals((CharSequence)stringBuffer);
        }
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (this.count != charSequence.length()) {
            return false;
        }
        if (charSequence instanceof AbstractStringBuilder) {
            char[] cArray = StringValue.inflateValue(this.value);
            char[] cArray2 = ((AbstractStringBuilder)charSequence).getValue();
            int n = this.offset;
            int n2 = 0;
            int n3 = this.count;
            while (n3-- != 0) {
                if (cArray[n++] == cArray2[n2++]) continue;
                return false;
            }
            return true;
        }
        if (charSequence.equals(this)) {
            return true;
        }
        char[] cArray = StringValue.inflateValue(this.value);
        int n = this.offset;
        int n4 = 0;
        int n5 = this.count;
        while (n5-- != 0) {
            if (cArray[n++] == charSequence.charAt(n4++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        return this == string ? true : string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    @Override
    public int compareTo(String string) {
        if (StringValue.is_byte_array(this.value) && StringValue.is_byte_array(string.value)) {
            return this.compareToCC(string);
        }
        return this.compareToX(string);
    }

    private int compareToX(String string) {
        int n = this.count;
        int n2 = string.count;
        int n3 = Math.min(n, n2);
        Object object = this.value;
        Object object2 = string.value;
        int n4 = this.offset;
        int n5 = string.offset;
        if (n4 == n5) {
            int n6 = n3 + n4;
            for (int i = n4; i < n6; ++i) {
                char c;
                char c2 = String.charAt(object, i);
                if (c2 == (c = String.charAt(object2, i))) continue;
                return c2 - c;
            }
        } else {
            while (n3-- != 0) {
                char c;
                char c3;
                if ((c3 = String.charAt(object, n4++)) == (c = String.charAt(object2, n5++))) continue;
                return c3 - c;
            }
        }
        return n - n2;
    }

    private int compareToCC(String string) {
        byte[] byArray = (byte[])this.value;
        byte[] byArray2 = (byte[])string.value;
        int n = this.count;
        int n2 = string.count;
        int n3 = Math.min(n, n2);
        int n4 = this.offset;
        int n5 = string.offset;
        if (n4 == n5) {
            int n6 = n3 + n4;
            for (int i = n4; i < n6; ++i) {
                byte by = byArray[i];
                byte by2 = byArray2[i];
                if (by == by2) continue;
                return by - by2;
            }
        } else {
            while (n3-- != 0) {
                byte by;
                byte by3;
                if ((by3 = byArray[n4++]) == (by = byArray2[n5++])) continue;
                return by3 - by;
            }
        }
        return n - n2;
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        Object object = this.value;
        int n4 = this.offset + n;
        Object object2 = string.value;
        int n5 = string.offset + n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.count - (long)n3 || (long)n2 > (long)string.count - (long)n3) {
            return false;
        }
        boolean bl = StringValue.is_byte_array(object);
        boolean bl2 = StringValue.is_byte_array(object2);
        if (!bl && !bl2) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            while (n3-- > 0) {
                char c;
                char c2;
                if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
                return false;
            }
        } else {
            while (n3-- > 0) {
                char c = bl ? (char)((byte[])object)[n4] : ((char[])object)[n4];
                char c3 = bl2 ? (char)((byte[])object2)[n5] : ((char[])object2)[n5];
                ++n4;
                ++n5;
                if (c == c3) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        Object object = this.value;
        int n4 = this.offset + n;
        Object object2 = string.value;
        int n5 = string.offset + n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.count - (long)n3 || (long)n2 > (long)string.count - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = String.charAt(object, n4++)) == (c3 = String.charAt(object2, n5++)) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        Object object = this.value;
        int n2 = this.offset + n;
        Object object2 = string.value;
        int n3 = string.offset;
        int n4 = string.count;
        if (n < 0 || n > this.count - n4) {
            return false;
        }
        boolean bl = StringValue.is_byte_array(object);
        boolean bl2 = StringValue.is_byte_array(object2);
        if (!bl && !bl2) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            while (--n4 >= 0) {
                char c;
                char c2;
                if ((c2 = cArray[n2++]) == (c = cArray2[n3++])) continue;
                return false;
            }
        } else {
            while (--n4 >= 0) {
                char c = bl ? (char)((byte[])object)[n2] : ((char[])object)[n2];
                char c3 = bl2 ? (char)((byte[])object2)[n3] : ((char[])object2)[n3];
                ++n2;
                ++n3;
                if (c == c3) continue;
                return false;
            }
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n = this.hash;
        int n2 = this.count;
        if (n == 0 && n2 > 0) {
            int n3 = this.offset;
            Object object = this.value;
            if (!StringValue.is_byte_array(object)) {
                char[] cArray = (char[])object;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + cArray[n3++];
                }
            } else {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + (char)byArray[n3++];
                }
            }
            this.hash = n;
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3;
        int n4 = this.offset + this.count;
        Object object = this.value;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        boolean bl = StringValue.is_byte_array(object);
        if (n < 65536) {
            for (n3 = this.offset + n2; n3 < n4; ++n3) {
                char c = bl ? (char)((byte[])object)[n3] : ((char[])object)[n3];
                if (c != n) continue;
                return n3 - this.offset;
            }
            return -1;
        }
        if (n <= 0x10FFFF) {
            char[] cArray = Character.toChars(n);
            while (n3 < n4) {
                char c = bl ? (char)((byte[])object)[n3] : ((char[])object)[n3];
                if (c == cArray[0]) {
                    if (n3 + 1 == n4) break;
                    char c2 = bl ? (char)((byte[])object)[n3 + 1] : ((char[])object)[n3 + 1];
                    if (c2 == cArray[1]) {
                        return n3 - this.offset;
                    }
                }
                ++n3;
            }
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3;
        int n4 = this.offset;
        Object object = this.value;
        if (n < 65536) {
            for (n3 = this.offset + (n2 >= this.count ? this.count - 1 : n2); n3 >= n4; --n3) {
                if (String.charAt(object, n3) != n) continue;
                return n3 - this.offset;
            }
            return -1;
        }
        int n5 = this.offset + this.count;
        if (n <= 0x10FFFF) {
            char[] cArray = Character.toChars(n);
            while (n3 >= n4) {
                if (String.charAt(object, n3) == cArray[0]) {
                    if (n3 + 1 == n5) break;
                    if (String.charAt(object, n3 + 1) == cArray[1]) {
                        return n3 - this.offset;
                    }
                }
                --n3;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        if (StringValue.is_byte_array(this.value) && StringValue.is_byte_array(string.value)) {
            return this.indexOfCC(string);
        }
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n);
    }

    int indexOf(Object object, int n, int n2, int n3) {
        return String.indexOf(object, n, n2, this.value, this.offset, this.count, n3);
    }

    static int indexOf(Object object, int n, int n2, Object object2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        if (StringValue.is_byte_array(object) && StringValue.is_byte_array(object2)) {
            return String.indexOfCC((byte[])object, n, n2, (byte[])object2, n3, n4, n5);
        }
        char c = String.charAt(object2, n3);
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            if (String.charAt(object, i) != c) {
                while (++i <= n6 && String.charAt(object, i) != c) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && String.charAt(object, n7) == String.charAt(object2, n9)) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    private int indexOfCC(String string) {
        byte[] byArray = (byte[])this.value;
        int n = this.offset;
        int n2 = this.count;
        byte[] byArray2 = (byte[])string.value;
        int n3 = string.offset;
        int n4 = string.count;
        if (n4 == 0) {
            return 0;
        }
        if (n4 > n2) {
            return -1;
        }
        return String.indexOfCC(byArray, n, n2, byArray2, n3, n4, 0);
    }

    private static int indexOfCC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        byte by = byArray2[n3];
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            if (byArray[i] != by) {
                while (++i <= n6 && byArray[i] != by) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && byArray[n7] == byArray2[n9]) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n);
    }

    int lastIndexOf(Object object, int n, int n2, int n3) {
        return String.lastIndexOf(object, n, n2, this.value, this.offset, this.count, n3);
    }

    static int lastIndexOf(Object object, int n, int n2, Object object2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n4;
        if (n5 < 0) {
            return -1;
        }
        if (n5 > n7) {
            n5 = n7;
        }
        if (n4 == 0) {
            return n5;
        }
        int n8 = n3 + n4 - 1;
        char c = String.charAt(object2, n8);
        int n9 = n + n4 - 1;
        int n10 = n9 + n5;
        block0: while (true) {
            if (n10 >= n9 && String.charAt(object, n10) != c) {
                --n10;
                continue;
            }
            if (n10 < n9) {
                return -1;
            }
            int n11 = n10 - 1;
            n6 = n11 - (n4 - 1);
            int n12 = n8 - 1;
            while (n11 > n6) {
                if (String.charAt(object, n11--) == String.charAt(object2, n12--)) continue;
                --n10;
                continue block0;
            }
            break;
        }
        return n6 - n + 1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.count ? this : new String(this.offset + n, n2 - n, this.value);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n, cArray, this.count);
        return new String(0, this.count + n, cArray);
    }

    public String replace(char c, char n) {
        if (c != n) {
            int n2 = this.count;
            int n3 = -1;
            Object object = this.value;
            int n4 = this.offset;
            while (++n3 < n2 && String.charAt(object, n4 + n3) != c) {
            }
            if (n3 < n2) {
                int n5;
                char[] cArray = n <= 127 && StringValue.is_byte_array(object) ? (Object[])new byte[n2] : new char[n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    String.setCharAt(cArray, n5, String.charAt(object, n4 + n5));
                }
                while (n3 < n2) {
                    n5 = String.charAt(object, n4 + n3);
                    String.setCharAt(cArray, n3, (char)(n5 == c ? n : n5));
                    ++n3;
                }
                return new String(0, n2, (Object)cArray);
            }
        }
        return this;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(((Object)charSequence).toString()) > -1;
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        return Pattern.compile(((Object)charSequence).toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(((Object)charSequence2).toString()));
    }

    public String[] split(String string, int n) {
        return Pattern.compile(string).split(this, n);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    public String toLowerCase(Locale locale) {
        int n;
        int n2;
        int n3;
        char[] cArray;
        block15: {
            if (locale == null) {
                throw new NullPointerException();
            }
            cArray = StringValue.inflateValue(this.value);
            n3 = 0;
            while (n3 < this.count) {
                char c = cArray[this.offset + n3];
                if (c >= '\ud800' && c <= '\udbff') {
                    n2 = this.codePointAt(n3);
                    if (n2 == Character.toLowerCase(n2)) {
                        n3 += Character.charCount(n2);
                        continue;
                    }
                } else if (c == Character.toLowerCase(c)) {
                    ++n3;
                    continue;
                }
                break block15;
            }
            return this;
        }
        char[] cArray2 = new char[this.count];
        n2 = 0;
        System.arraycopy(cArray, this.offset, cArray2, 0, n3);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n3; i < this.count; i += n) {
            int n4 = cArray[this.offset + i];
            if ((char)n4 >= '\ud800' && (char)n4 <= '\udbff') {
                n4 = this.codePointAt(i);
                n = Character.charCount(n4);
            } else {
                n = 1;
            }
            int n5 = bl || n4 == 931 ? ConditionalSpecialCasing.toLowerCaseEx(this, i, locale) : Character.toLowerCase(n4);
            if (n5 == -1 || n5 >= 65536) {
                char[] cArray3;
                if (n5 == -1) {
                    cArray3 = ConditionalSpecialCasing.toLowerCaseCharArray(this, i, locale);
                } else {
                    if (n == 2) {
                        n2 += Character.toChars(n5, cArray2, i + n2) - n;
                        continue;
                    }
                    cArray3 = Character.toChars(n5);
                }
                int n6 = cArray3.length;
                if (n6 > n) {
                    char[] cArray4 = new char[cArray2.length + n6 - n];
                    System.arraycopy(cArray2, 0, cArray4, 0, i + n2);
                    cArray2 = cArray4;
                }
                for (int j = 0; j < n6; ++j) {
                    cArray2[i + n2 + j] = cArray3[j];
                }
                n2 += n6 - n;
                continue;
            }
            cArray2[i + n2] = (char)n5;
        }
        return new String(0, this.count + n2, cArray2);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int n;
        int n2;
        int n3;
        char[] cArray;
        block14: {
            if (locale == null) {
                throw new NullPointerException();
            }
            cArray = StringValue.inflateValue(this.value);
            for (n2 = 0; n2 < this.count; n2 += n3) {
                int n4 = cArray[this.offset + n2];
                if (n4 >= 55296 && n4 <= 56319) {
                    n4 = this.codePointAt(n2);
                    n3 = Character.charCount(n4);
                } else {
                    n3 = 1;
                }
                int n5 = Character.toUpperCaseEx(n4);
                if (n5 != -1 && n4 == n5) {
                    continue;
                }
                break block14;
            }
            return this;
        }
        char[] cArray2 = new char[this.count];
        n3 = 0;
        System.arraycopy(cArray, this.offset, cArray2, 0, n2);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n2; i < this.count; i += n) {
            int n6 = cArray[this.offset + i];
            if ((char)n6 >= '\ud800' && (char)n6 <= '\udbff') {
                n6 = this.codePointAt(i);
                n = Character.charCount(n6);
            } else {
                n = 1;
            }
            int n7 = bl ? ConditionalSpecialCasing.toUpperCaseEx(this, i, locale) : Character.toUpperCaseEx(n6);
            if (n7 == -1 || n7 >= 65536) {
                char[] cArray3;
                if (n7 == -1) {
                    cArray3 = bl ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i, locale) : Character.toUpperCaseCharArray(n6);
                } else {
                    if (n == 2) {
                        n3 += Character.toChars(n7, cArray2, i + n3) - n;
                        continue;
                    }
                    cArray3 = Character.toChars(n7);
                }
                int n8 = cArray3.length;
                if (n8 > n) {
                    char[] cArray4 = new char[cArray2.length + n8 - n];
                    System.arraycopy(cArray2, 0, cArray4, 0, i + n3);
                    cArray2 = cArray4;
                }
                for (int j = 0; j < n8; ++j) {
                    cArray2[i + n3 + j] = cArray3[j];
                }
                n3 += n8 - n;
                continue;
            }
            cArray2[i + n3] = (char)n7;
        }
        return new String(0, this.count + n3, cArray2);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n;
        int n2 = this.count;
        int n3 = this.offset;
        char[] cArray = StringValue.inflateValue(this.value);
        for (n = 0; n < n2 && cArray[n3 + n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[n3 + n2 - 1] <= ' ') {
            --n2;
        }
        return n > 0 || n2 < this.count ? this.substring(n, n2) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        this.getChars(0, this.count, cArray, 0);
        return cArray;
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
                char c;
                char c2 = string.charAt(n3);
                if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }
}

