/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

public final class ByteArrayToFromHexDigits {
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final boolean debug = false;

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("argument null or zero length");
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.insert(i * 2, chars[byArray[i] >> 4 & 0xF]);
            stringBuffer.insert(i * 2 + 1, chars[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static byte hexCharToByte(char c) throws IllegalArgumentException {
        if (c < '0' || c < 'A' && c > 'F' && c < 'a' && c > 'f') {
            throw new IllegalArgumentException("not a hex digit");
        }
        if (c > '9') {
            if (c > 'F') {
                return (byte)(c - 97 + 10 & 0xF);
            }
            return (byte)(c - 65 + 10 & 0xF);
        }
        return (byte)(c - 48 & 0xF);
    }

    public static byte[] hexStringToBytes(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("parameter cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("parameter cannot be zero length");
        }
        if ((string.length() & 1) != 0) {
            throw new IllegalArgumentException("odd length string");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)((ByteArrayToFromHexDigits.hexCharToByte(string.charAt(i)) << 4) + ByteArrayToFromHexDigits.hexCharToByte(string.charAt(i + 1)));
        }
        return byArray;
    }
}

