/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.peer.PopupMenuPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class PopupMenu
extends Menu {
    private static final String base = "popup";
    static int nameCounter = 0;
    transient boolean isTrayIconPopup = false;
    private static final long serialVersionUID = -4620452533522760060L;

    public PopupMenu() throws HeadlessException {
        this("");
    }

    public PopupMenu(String string) throws HeadlessException {
        super(string);
    }

    public MenuContainer getParent() {
        if (this.isTrayIconPopup) {
            return null;
        }
        return super.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && !(this.parent instanceof Component)) {
                super.addNotify();
            } else {
                if (this.peer == null) {
                    this.peer = Toolkit.getDefaultToolkit().createPopupMenu(this);
                }
                int n = this.getItemCount();
                for (int i = 0; i < n; ++i) {
                    MenuItem menuItem = this.getItem(i);
                    menuItem.parent = this;
                    menuItem.addNotify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Component component, int n, int n2) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer == null) {
            throw new NullPointerException("parent is null");
        }
        if (!(menuContainer instanceof Component)) {
            throw new IllegalArgumentException("PopupMenus with non-Component parents cannot be shown");
        }
        Component component2 = (Component)menuContainer;
        if (component2 != component) {
            if (component2 instanceof Container) {
                if (!((Container)component2).isAncestorOf(component)) {
                    throw new IllegalArgumentException("origin not in parent's hierarchy");
                }
            } else {
                throw new IllegalArgumentException("origin not in parent's hierarchy");
            }
        }
        if (component2.getPeer() == null || !component2.isShowing()) {
            throw new RuntimeException("parent not showing on screen");
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer != null) {
                ((PopupMenuPeer)this.peer).show(new Event(component, 0L, 501, n, n2, 0, 0));
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTPopupMenu();
        }
        return this.accessibleContext;
    }

    static {
        AWTAccessor.setPopupMenuAccessor(new AWTAccessor.PopupMenuAccessor(){

            public boolean isTrayIconPopup(PopupMenu popupMenu) {
                return popupMenu.isTrayIconPopup;
            }
        });
    }

    protected class AccessibleAWTPopupMenu
    extends Menu.AccessibleAWTMenu {
        private static final long serialVersionUID = -4282044795947239955L;

        protected AccessibleAWTPopupMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }
}

