/*
 * Created on 08-ago-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.undo;

import java.util.ArrayList;
import java.util.List;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class UndoManager {
    private static final int LIMIT = 5;
    private int indexOfNextAdd;
    private List edits;
    
    public UndoManager() {
        this.init();
    }

    public void discardAllEdits() {
        this.reset();
    }

    public synchronized void undo() throws CannotUndoException {
        UndoableEdit edit = editToBeUndone();
        if (edit == null) {
            throw new CannotUndoException();
        }
        edit.undo();
        indexOfNextAdd--;
    }

    public synchronized void redo() throws CannotRedoException {
        UndoableEdit edit = editToBeRedone();
        if (edit == null) {
            throw new CannotRedoException();
        }
        edit.redo();
        indexOfNextAdd++;
    }

    public synchronized boolean canUndo() {
        boolean canUndo = false;
        UndoableEdit edit = editToBeUndone();
        if (edit != null) {
            canUndo = edit.canUndo();
        }
        return canUndo;
    }

    public synchronized boolean canRedo() {
        boolean canRedo = false;
        UndoableEdit edit = editToBeRedone();
        if (edit != null) {
            canRedo = edit.canRedo();
        }
        return canRedo;
    }

    public synchronized void addEdit(UndoableEdit anEdit) {
        checkForUnused();
        checkForLimit();
        edits.add(indexOfNextAdd, anEdit);
        indexOfNextAdd++;
    }

    public boolean shift() {                
        if(!edits.isEmpty()){
            UndoableEdit edit = (UndoableEdit) edits.get(0);            
            remove(edit);
            indexOfNextAdd--;
            return true;
        }        
        return false;
    }    


    private void checkForUnused() {
        while (edits.size() > indexOfNextAdd) {
            UndoableEdit edit = (UndoableEdit) edits.get(indexOfNextAdd);
            remove(edit);
        }
    }

    
    private void checkForLimit() {
        while (edits.size() >= LIMIT) {
            UndoableEdit edit = (UndoableEdit) edits.get(0);
            remove(edit);
            indexOfNextAdd--;
        }
    }

    private void remove(UndoableEdit edit) {
        edits.remove(edit);
    }

    private UndoableEdit editToBeUndone() {
        int index = indexOfNextAdd - 1;
        if (index >= 0 && index < edits.size()) {
            return (UndoableEdit) edits.get(index);
        }
        return null;
    }

    private UndoableEdit editToBeRedone() {
        int index = indexOfNextAdd;
        if (index >= 0 && index < edits.size()) {
            return (UndoableEdit) edits.get(index);
        }
        return null;
    }

    private void init() {
        this.indexOfNextAdd = 0;
        this.edits = new ArrayList();        
    }    
    
    private void reset() {
        this.indexOfNextAdd = 0;
        this.edits.clear();                
    }

}

