/*
 * Created on 18-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.RepeatToolItems;
import org.herac.tuxguitar.gui.items.tool.TiedNoteToolItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ItemContainerManager {
    private TablatureEditor tablatureEditor;
    private List items;
    
    public ItemContainerManager(TablatureEditor tablatureEditor){
        this.tablatureEditor = tablatureEditor;
        this.items = new ArrayList();
    }
    
    public void createToolbar(Shell shell) {
        ToolBar toolBar = new ToolBar(shell,SWT.FLAT);
        toolBar.setLayout(new GridLayout());
        
        ItemContainer fileItems = new FileToolItems(tablatureEditor, toolBar);
        ItemContainer compositionItems = new CompositionToolItems(tablatureEditor, toolBar);
        ItemContainer durationItems = new DurationToolItems(tablatureEditor, toolBar);
        ItemContainer repeatItems = new RepeatToolItems(tablatureEditor, toolBar);
        ItemContainer tiedNoteItems = new TiedNoteToolItems(tablatureEditor, toolBar);
        ItemContainer playerItems = new PlayerToolItems(tablatureEditor, toolBar);

        fileItems.showItems();
        final ToolItem separator2 = new ToolItem(toolBar, SWT.SEPARATOR);
        durationItems.showItems();
        final ToolItem separator3 = new ToolItem(toolBar, SWT.SEPARATOR);
        playerItems.showItems();
        final ToolItem separator4 = new ToolItem(toolBar, SWT.SEPARATOR);
        compositionItems.showItems();
        repeatItems.showItems();
        tiedNoteItems.showItems();
        
        this.items.add(fileItems);
        this.items.add(compositionItems);
        this.items.add(durationItems);
        this.items.add(repeatItems);
        this.items.add(tiedNoteItems);
        this.items.add(playerItems);
        
    }    
    
    public void createMenu(Shell shell) {
        Menu menuBar = new Menu(shell, SWT.BAR);

        ItemContainer fileItem = new FileMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer compositionItem = new CompositionMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer trackItem = new TrackMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer measureItem = new MeasureMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer durationItem = new DurationMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer playItem = new PlayMenuItem(shell,menuBar, SWT.CASCADE,tablatureEditor);
        ItemContainer helpItem = new HelpMenuItem(shell,menuBar, SWT.CASCADE);

        fileItem.showItems();
        compositionItem.showItems();
        helpItem.showItems();
        trackItem.showItems();
        measureItem.showItems();
        durationItem.showItems();
        playItem.showItems();
        
        shell.setMenuBar(menuBar);
        
        this.items.add(fileItem);
        this.items.add(compositionItem);
        this.items.add(trackItem);
        this.items.add(measureItem);
        this.items.add(durationItem);
        this.items.add(playItem);  
        this.items.add(helpItem);      
    }    
    
    
    public void updateItems(){
        Iterator it = this.items.iterator();
        while(it.hasNext()){
            ItemContainer item = (ItemContainer)it.next();
            item.update();            
        }
    }
}
