/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SelectInstrumentTrackAction extends Action{
    public static final String NAME = "SELECT_INSTRUMENT_TRACK";
    
    
    private Instrument[] instruments;
    
    public SelectInstrumentTrackAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        SongTrack track = getEditor().getTablature().getCaret().getSongTrackCoords().getTrack();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 10;      
            layout.horizontalSpacing = 10;     
            dialog.setLayout(layout);

            //------------Instrument Combo-------------------------------------
            Label instrumentLabel = new Label(dialog, SWT.NULL);
            instrumentLabel.setText("Instrument:");
            final Combo instrumentCombo = new Combo(dialog, SWT.NULL);
            Instrument[] instruments = getInstruments();
            int count = instruments.length;
            if(count > 128){
                count = 128;
            }
            for (int i = 0; i < count; i++) {
                instruments[i].getName();
                instrumentCombo.add(instruments[i].getName());
            }               
            instrumentCombo.setText(instruments[track.getInstrument()].getName()); 
            instrumentCombo.setEnabled(!track.isPercusionTrack());
            

            //--------------------Precusion CheckBox-------------------------------
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;           
            final Button percusion = new Button(dialog, SWT.CHECK);
            percusion.setText("Percusion Track");
            percusion.setLayoutData(gridData);
            percusion.setSelection(track.isPercusionTrack());
            percusion.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    instrumentCombo.setEnabled(!percusion.getSelection());
                }
            });
            //-----------------------------------------------------------            
            
            
            final Button buttonOK = new Button(dialog, SWT.PUSH);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   

                    setInstrument(instrumentCombo.getSelectionIndex(),percusion.getSelection());
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(dialog, SWT.PUSH);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
    
    
    
    private Instrument[] getInstruments(){
        if(this.instruments == null){
            this.instruments = loadInstruments();
        }
        return this.instruments;
    }
    
	private Instrument[] loadInstruments() {
	    Instrument[] instruments = null;
	    try {	    		
		
	        Synthesizer synthesizer = MidiSystem.getSynthesizer();	        
			synthesizer.open();
		
			Soundbank sb = synthesizer.getDefaultSoundbank();
			if (sb != null) {
			    instruments = sb.getInstruments();
			}
			synthesizer.close();
        } catch (MidiUnavailableException e) {
            e.printStackTrace();
        }		

		return instruments;
	}        
    
    
    private void setInstrument(int instrument,boolean percusion){
        Caret caret = getEditor().getTablature().getCaret();
        SongTrack track = caret.getSongTrackCoords().getTrack();
        if(percusion){
            track.setChannel(getEditor().getSongManager().getFreeChannel(instrument,percusion));
            track.setInstrument(instrument);
            track.setStrings(SongManager.createPercusionStrings());
        }else{
            if(track.isPercusionTrack()){
                track.setStrings(SongManager.createDefaultInstrumentStrings());
            }
            
            track.setChannel(getEditor().getSongManager().getFreeChannel(instrument,percusion));
            track.setInstrument(instrument);            
        }        
    }
    
  
}
