/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLEventWriterRecord
extends MarshalRecord {
    private Map<String, String> prefixMapping;
    private NamespaceResolver namespaceResolver;
    private XMLEventWriter xmlEventWriter;
    private XMLEventFactory xmlEventFactory;
    private DomToXMLEventWriter domToXMLEventWriter;
    private boolean isStartElementOpen = false;
    private List attributes;
    private List namespaceDeclarations;
    private XPathFragment xPathFragment;

    public XMLEventWriterRecord(XMLEventWriter xmlEventWriter) {
        this.xmlEventWriter = xmlEventWriter;
        this.xmlEventFactory = XMLEventFactory.newInstance();
        this.domToXMLEventWriter = new DomToXMLEventWriter(this.xmlEventFactory);
    }

    public XMLEventWriter getXMLEventWriter() {
        return this.xmlEventWriter;
    }

    public void setXMLEventWriter(XMLEventWriter anXMLEventWriter) {
        this.xmlEventWriter = anXMLEventWriter;
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        Attribute event;
        String namespaceURI = xPathFragment.getNamespaceURI();
        if (namespaceURI == null) {
            event = this.xmlEventFactory.createAttribute(xPathFragment.getLocalName(), value);
        } else {
            String prefix = xPathFragment.getPrefix();
            if (prefix == null) {
                event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
            } else {
                if (this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix) == null || !this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix).equals(namespaceURI)) {
                    event = this.xmlEventFactory.createNamespace(prefix, namespaceURI);
                    try {
                        this.xmlEventWriter.setPrefix(prefix, namespaceURI);
                    }
                    catch (XMLStreamException e) {
                        throw XMLMarshalException.marshalException(e);
                    }
                }
                event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
            }
        }
        if (event.isNamespace()) {
            if (null == this.namespaceDeclarations) {
                this.namespaceDeclarations = new ArrayList();
            }
            this.namespaceDeclarations.add(event);
        } else {
            if (null == this.attributes) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(event);
        }
    }

    public void attribute(String namespaceURI, String localName, String name, String value) {
        Attribute event;
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            try {
                if ("xmlns".equals(localName)) {
                    event = this.xmlEventFactory.createNamespace(value);
                    this.xmlEventWriter.setDefaultNamespace(value);
                }
                event = this.xmlEventFactory.createNamespace(localName, value);
                this.xmlEventWriter.setPrefix(localName, value);
            }
            catch (XMLStreamException e) {
                throw XMLMarshalException.marshalException(e);
            }
        } else {
            NamespaceContext ctx = this.xmlEventWriter.getNamespaceContext();
            if (namespaceURI == null || namespaceURI.length() == 0) {
                event = this.xmlEventFactory.createAttribute(localName, value);
            } else {
                int index = name.indexOf(58);
                if (index == -1) {
                    event = this.xmlEventFactory.createAttribute("", namespaceURI, localName, value);
                } else {
                    String prefix = name.substring(0, index);
                    event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, localName, value);
                }
            }
        }
        if (event.isNamespace()) {
            if (null == this.namespaceDeclarations) {
                this.namespaceDeclarations = new ArrayList();
            }
            this.namespaceDeclarations.add(event);
        } else {
            if (null == this.attributes) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(event);
        }
    }

    private void openAndCloseStartElement() {
        try {
            String namespaceURI = this.xPathFragment.getNamespaceURI();
            if (null == namespaceURI) {
                Iterator attributesIterator = null;
                if (null != this.attributes) {
                    attributesIterator = this.attributes.iterator();
                }
                Iterator namespaceDeclarationsIterator = null;
                if (null != this.namespaceDeclarations) {
                    namespaceDeclarationsIterator = this.namespaceDeclarations.iterator();
                }
                this.xmlEventWriter.add(this.xmlEventFactory.createStartElement("", "", this.xPathFragment.getLocalName(), attributesIterator, namespaceDeclarationsIterator));
                String defaultNamespace = this.xmlEventWriter.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    this.xmlEventWriter.setDefaultNamespace("");
                    this.xmlEventWriter.add(this.xmlEventFactory.createNamespace(""));
                }
            } else {
                String prefix = this.xPathFragment.getPrefix();
                if (null == prefix) {
                    prefix = "";
                }
                Iterator attributesIterator = null;
                if (null != this.attributes) {
                    attributesIterator = this.attributes.iterator();
                }
                Iterator namespaceDeclarationsIterator = null;
                if (null != this.namespaceDeclarations) {
                    namespaceDeclarationsIterator = this.namespaceDeclarations.iterator();
                }
                this.xmlEventWriter.add(this.xmlEventFactory.createStartElement(prefix, namespaceURI, this.xPathFragment.getLocalName(), attributesIterator, namespaceDeclarationsIterator));
            }
        }
        catch (XMLStreamException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createCData(value));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createCharacters(value));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.xPathFragment = xPathFragment;
        this.attributes = null;
        this.namespaceDeclarations = null;
        this.writePrefixMappings();
    }

    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            String namespaceURI = frag.getNamespaceURI();
            String localName = frag.getLocalName();
            String prefix = frag.getPrefix();
            if (null == prefix) {
                prefix = "";
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createStartElement(prefix, namespaceURI, localName));
            this.xmlEventWriter.add(this.xmlEventFactory.createEndElement(prefix, namespaceURI, localName));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createEndDocument());
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment pathFragment, NamespaceResolver namespaceResolver) {
        String prefix;
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        if (null == (prefix = pathFragment.getPrefix())) {
            prefix = "";
        }
        try {
            this.xmlEventWriter.add(this.xmlEventFactory.createEndElement(prefix, this.xPathFragment.getNamespaceURI(), pathFragment.getLocalName()));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver resolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            this.domToXMLEventWriter.writeToEventWriter(node, this.xmlEventWriter);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startDocument(String encoding, String version) {
        try {
            this.xmlEventWriter.add(this.xmlEventFactory.createStartDocument(encoding, version, false));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceUri) {
        if (null == this.prefixMapping) {
            this.prefixMapping = new HashMap<String, String>();
        }
        this.prefixMapping.put(prefix, namespaceUri);
    }

    private void writePrefixMappings() {
        if (null != this.namespaceResolver) {
            String defaultNamespace = this.namespaceResolver.getDefaultNamespaceURI();
            if (defaultNamespace != null) {
                Namespace namespace = this.xmlEventFactory.createNamespace("", defaultNamespace);
                if (null == this.namespaceDeclarations) {
                    this.namespaceDeclarations = new ArrayList();
                }
                this.namespaceDeclarations.add(namespace);
            }
            for (Map.Entry<String, String> entry : this.namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                Namespace namespace = this.xmlEventFactory.createNamespace(entry.getKey(), entry.getValue());
                if (null == this.namespaceDeclarations) {
                    this.namespaceDeclarations = new ArrayList();
                }
                this.namespaceDeclarations.add(namespace);
            }
            this.namespaceResolver = null;
        }
        if (null != this.prefixMapping) {
            for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                Namespace namespace = this.xmlEventFactory.createNamespace(entry.getKey(), entry.getValue());
                if (null == this.namespaceDeclarations) {
                    this.namespaceDeclarations = new ArrayList();
                }
                this.namespaceDeclarations.add(namespace);
            }
            this.prefixMapping = null;
        }
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }
}

