/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.jpa.gen.internal.JptGenMessages;
import org.eclipse.jpt.jpa.gen.internal.util.UrlUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FileUtil {
    public static void deleteFolder(File folder) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    FileUtil.deleteFolder(f);
                } else {
                    FileUtil.deletePath(f);
                }
                ++i;
            }
        }
        FileUtil.deletePath(folder);
    }

    public static void deletePath(File f) throws IOException {
        if (!f.delete()) {
            String msgId = f.isDirectory() ? JptGenMessages.Delete_Folder_Error : JptGenMessages.Delete_File_Error;
            throw new IOException(NLS.bind((String)msgId, (Object)f.getPath()));
        }
    }

    public static byte[] readFile(File src) throws IOException {
        FileInputStream fin = new FileInputStream(src);
        try {
            long fileLen = src.length();
            if (fileLen > Integer.MAX_VALUE) {
                throw new IOException("file length too big to be read by FileUtil.readFile: " + fileLen);
            }
            byte[] bytes = new byte[(int)fileLen];
            fin.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            fin.close();
        }
    }

    public static void writeFile(File dest, byte[] bytes) throws IOException {
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException(NLS.bind((String)JptGenMessages.File_Read_Only_Error, (Object)dest.getPath()));
        }
        FileOutputStream fout = new FileOutputStream(dest.getPath(), false);
        try {
            fout.write(bytes);
        }
        finally {
            fout.flush();
            fout.close();
        }
    }

    public static URL getFileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void setFileContent(File file, InputStream contents) throws IOException {
        Path path = new Path(file.getAbsolutePath());
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (iFile == null) {
                throw new IOException("The path " + file + " does not seem to be a valid file path.");
            }
            iFile.setContents(contents, true, true, null);
        }
        catch (CoreException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void unjar(InputStream in, File dest) throws IOException {
        FileOutputStream out;
        File parent;
        File file;
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!dest.isDirectory()) {
            throw new IOException("Destination must be a directory.");
        }
        JarInputStream jin = new JarInputStream(in);
        byte[] buffer = new byte[1024];
        ZipEntry entry = jin.getNextEntry();
        while (entry != null) {
            String fileName = entry.getName();
            if (fileName.charAt(fileName.length() - 1) == '/') {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            if (fileName.charAt(0) == '/') {
                fileName = fileName.substring(1);
            }
            if (File.separatorChar != '/') {
                fileName = fileName.replace('/', File.separatorChar);
            }
            file = new File(dest, fileName);
            if (entry.isDirectory()) {
                file.mkdirs();
                jin.closeEntry();
            } else {
                parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new FileOutputStream(file);
                int len = 0;
                while ((len = jin.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                out.flush();
                ((OutputStream)out).close();
                jin.closeEntry();
                file.setLastModified(entry.getTime());
            }
            entry = jin.getNextEntry();
        }
        Manifest mf = jin.getManifest();
        if (mf != null) {
            file = new File(dest, "META-INF/MANIFEST.MF");
            parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            out = new FileOutputStream(file);
            mf.write(out);
            out.flush();
            ((OutputStream)out).close();
        }
        jin.close();
    }

    public static File extractFilesFromBundle(URL url, Bundle bundle, String path) throws Exception {
        URL jarUrl = UrlUtil.getJarFileUrl(url);
        File jarFile = new File(jarUrl.getFile());
        Location configLocation = Platform.getConfigurationLocation();
        String pluginId = bundle.getSymbolicName();
        File configFolder = new File(configLocation.getURL().getFile(), pluginId);
        File templDir = new File(configFolder, path);
        if (!templDir.exists()) {
            File[] files;
            FileUtil.unjar(new FileInputStream(jarFile), configFolder);
            File[] fileArray = files = configFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    f.delete();
                } else if (templDir.getPath().indexOf(f.getPath()) != 0) {
                    FileUtil.deleteFolder(f);
                }
                ++n2;
            }
        }
        return templDir;
    }
}

