/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;

public class ClasspathJarFile {
    private final IProject _project;
    private final IPath _iPath;

    public ClasspathJarFile(IProject project, IPath iPath) {
        this._project = project;
        this._iPath = iPath;
    }

    public IProject getProject() {
        return this._project;
    }

    public IPath getPath() {
        return this._iPath;
    }

    public JarFile getJarFile() {
        JarFile jarFileFromCPE = null;
        try {
            jarFileFromCPE = this.getJarFileFromCPE(this._iPath, this._project.getWorkspace());
        }
        catch (IOException e) {
            JSFCommonPlugin.log(e);
        }
        return jarFileFromCPE;
    }

    private JarFile getJarFileFromCPE(IPath entry, IWorkspace workspace) throws IOException {
        IPath path = this._iPath;
        if (path.getFileExtension() != null && path.getFileExtension().length() > 0) {
            String libraryPathString;
            File file;
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            if (path.getDevice() == null && workspaceRoot.getProject(path.segment(0)).exists()) {
                path = workspaceRoot.getFile(path).getLocation();
            }
            if ((file = new File(libraryPathString = path.toString())).exists()) {
                return new JarFile(file);
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClasspathJarFile)) {
            return false;
        }
        ClasspathJarFile other = (ClasspathJarFile)obj;
        return this._project.equals((Object)other._project) && this._iPath.equals((Object)other._iPath);
    }

    public int hashCode() {
        return this._project.hashCode() ^ this._iPath.hashCode();
    }

    public String toString() {
        return String.format("ClasspathJarFile for project=%s, entry=%s", this._project, this._iPath);
    }
}

