/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2117
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean rpcLiteralFound = false;
    private ErrorList errors = new ErrorList();

    public BP2117(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("style", style);
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        if ("literal".equals(body.getUse()) && ((String)ctx.getParameter("style")).equals("rpc")) {
            this.rpcLiteralFound = true;
        }
    }

    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        String style = operation.getStyle();
        if (style == null) {
            style = (String)ctx.getParameter("style");
        }
        if (!"rpc".equals(style)) {
            ctx.cancelBindingOperationProcessing();
        }
    }

    public void visit(SOAPHeader header, Object parent, WSDLTraversalContext ctx) {
        this.check(header.getUse(), header.getNamespaceURI(), ctx);
    }

    public void visit(SOAPHeaderFault fault, Object parent, WSDLTraversalContext ctx) {
        this.check(fault.getUse(), fault.getNamespaceURI(), ctx);
    }

    public void visit(SOAPFault fault, Object parent, WSDLTraversalContext ctx) {
        this.check(fault.getUse(), fault.getNamespaceURI(), ctx);
    }

    private void check(String use, String namespace, WSDLTraversalContext ctx) {
        if ("literal".equals(use) && namespace != null) {
            this.errors.add(ctx.getBinding().getQName());
            ctx.cancelProcessing();
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPHeader(true);
        traversal.visitSOAPHeaderFault(true);
        traversal.visitSOAPFault(true);
        traversal.visitSOAPOperation(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.rpcLiteralFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

