/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.schemagen;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jpt.jaxb.eclipselink.core.schemagen.internal.Tools;

class JptSchemaOutputResolver
extends SchemaOutputResolver {
    private String defaultSchemaName;

    protected JptSchemaOutputResolver(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
        String filePath = Tools.stringIsEmpty(namespaceURI) ? this.buildFileNameFrom(this.defaultSchemaName, suggestedFileName) : this.modifyFileName(namespaceURI);
        File file = new File(filePath);
        StreamResult result = new StreamResult(file);
        result.setSystemId(file.toURI().toURL().toString());
        System.out.print(Tools.bind("SCHEMA_GENERATED", file));
        return result;
    }

    private String buildFileNameFrom(String fileName, String suggestedFileName) {
        if (Tools.stringIsEmpty(fileName = Tools.stripExtension(fileName))) {
            return suggestedFileName;
        }
        String number = Tools.extractFileNumber(suggestedFileName);
        fileName = this.buildFileName(fileName, number);
        return Tools.appendXsdExtension(fileName);
    }

    private String buildFileName(String fileName, String number) {
        if (Tools.stringIsEmpty(number)) {
            return fileName;
        }
        return number.equals("0") ? fileName : String.valueOf(fileName) + number;
    }

    private String modifyFileName(String namespaceURI) throws IOException {
        String dir = Tools.extractDirectory(this.defaultSchemaName);
        String fileName = Tools.stripProtocol(namespaceURI);
        fileName = fileName.replaceAll("/", "_");
        fileName = Tools.appendXsdExtension(fileName);
        String result = Tools.stringIsEmpty(dir) ? fileName : String.valueOf(dir) + File.separator + fileName;
        return result;
    }
}

