/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IJPAVersion {
    DEFAULT_VERSION(2.0),
    VERSION_1_0(1.0),
    VERSION_2_0(2.0);

    private double version;

    private IJPAVersion(double version) {
        this.version = version;
    }

    public static IJPAVersion value(String value) {
        for (IJPAVersion version : IJPAVersion.versions()) {
            if (!version.getVersion().equals(value)) continue;
            return version;
        }
        return DEFAULT_VERSION;
    }

    public static IJPAVersion[] versions() {
        List<IJPAVersion> values = Arrays.asList(IJPAVersion.values());
        values.remove((Object)DEFAULT_VERSION);
        return values.toArray(new IJPAVersion[values.size()]);
    }

    public String getVersion() {
        return String.valueOf(this.version);
    }

    public boolean isNewerThan(IJPAVersion version) {
        return this.version > version.version;
    }

    public boolean isNewerThanOrEqual(IJPAVersion version) {
        return this.version >= version.version;
    }

    public boolean isOlderThan(IJPAVersion version) {
        return this.version < version.version;
    }

    public boolean isOlderThanOrEqual(IJPAVersion version) {
        return this.version <= version.version;
    }

    public IJPAVersion toCurrentVersion() {
        if (this == DEFAULT_VERSION) {
            String currentVersion = this.getVersion();
            for (IJPAVersion version : IJPAVersion.versions()) {
                if (!currentVersion.equals(version.version)) continue;
                return version;
            }
        }
        return this;
    }

    public String toString() {
        return this.getVersion();
    }
}

