/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateClause
extends AbstractExpression {
    private boolean hasSet;
    private boolean hasSpaceAfterRangeVariableDeclaration;
    private boolean hasSpaceAfterSet;
    private boolean hasSpaceAfterUpdate;
    private AbstractExpression rangeVariableDeclaration;
    private AbstractExpression updateItems;

    UpdateClause(AbstractExpression parent) {
        super(parent, "UPDATE");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRangeVariableDeclaration().accept(visitor);
        this.getUpdateItems().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRangeVariableDeclaration());
        children.add(this.getUpdateItems());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("UPDATE"));
        if (this.hasSpaceAfterUpdate) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.rangeVariableDeclaration != null) {
            children.add(this.rangeVariableDeclaration);
        }
        if (this.hasSpaceAfterRangeVariableDeclaration) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasSet) {
            children.add(this.buildStringExpression("SET"));
        }
        if (this.hasSpaceAfterSet) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.updateItems != null) {
            children.add(this.updateItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getUpdateItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return UpdateClause.queryBNF("update_clause");
    }

    public Expression getRangeVariableDeclaration() {
        if (this.rangeVariableDeclaration == null) {
            this.rangeVariableDeclaration = this.buildNullExpression();
        }
        return this.rangeVariableDeclaration;
    }

    public Expression getUpdateItems() {
        if (this.updateItems == null) {
            this.updateItems = this.buildNullExpression();
        }
        return this.updateItems;
    }

    public boolean hasRangeVariableDeclaration() {
        return this.rangeVariableDeclaration != null && !this.rangeVariableDeclaration.isNull();
    }

    public boolean hasSet() {
        return this.hasSet;
    }

    public boolean hasSpaceAfterRangeVariableDeclaration() {
        return this.hasSpaceAfterRangeVariableDeclaration;
    }

    public boolean hasSpaceAfterSet() {
        return this.hasSpaceAfterSet;
    }

    public boolean hasSpaceAfterUpdate() {
        return this.hasSpaceAfterUpdate;
    }

    public boolean hasUpdateItems() {
        return this.updateItems != null && !this.updateItems.isNull();
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("SET") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("UPDATE");
        boolean bl = this.hasSpaceAfterUpdate = wordParser.skipLeadingWhitespace() > 0;
        if (tolerant && !wordParser.startsWithIdentifier("SET")) {
            this.rangeVariableDeclaration = this.parse(wordParser, (JPQLQueryBNF)UpdateClause.queryBNF("range_variable_declaration"), tolerant);
        } else if (!tolerant) {
            this.rangeVariableDeclaration = new RangeVariableDeclaration(this);
            this.rangeVariableDeclaration.parse(wordParser, tolerant);
        }
        this.hasSpaceAfterRangeVariableDeclaration = wordParser.skipLeadingWhitespace() > 0;
        boolean bl2 = this.hasSet = tolerant ? wordParser.startsWithIdentifier("SET") : true;
        if (this.hasSet) {
            wordParser.moveForward("SET");
            this.hasSpaceAfterSet = wordParser.skipLeadingWhitespace() > 0;
        }
        this.updateItems = this.parse(wordParser, (JPQLQueryBNF)UpdateClause.queryBNF("update_item*"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append("UPDATE");
        if (this.hasSpaceAfterUpdate) {
            writer.append(' ');
        }
        if (this.rangeVariableDeclaration != null) {
            this.rangeVariableDeclaration.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterRangeVariableDeclaration) {
            writer.append(' ');
        }
        if (this.hasSet) {
            writer.append("SET");
        }
        if (this.hasSpaceAfterSet) {
            writer.append(' ');
        }
        if (this.updateItems != null) {
            this.updateItems.toParsedText(writer, includeVirtual);
        }
    }
}

