/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinFetch
extends AbstractExpression {
    private boolean hasSpaceAfterFetch;
    private AbstractExpression joinAssociationPath;

    JoinFetch(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getJoinAssociationPath().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getJoinAssociationPath());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        String space;
        String joinType = this.getIdentifier().toString();
        if (joinType.indexOf(space = " ") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(joinType, space, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                children.add(this.buildStringExpression(token));
            }
        } else {
            children.add(this.buildStringExpression(joinType));
        }
        if (this.hasSpaceAfterFetch) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joinAssociationPath != null) {
            children.add(this.joinAssociationPath);
        }
    }

    public String getIdentifier() {
        return this.getText();
    }

    public Expression getJoinAssociationPath() {
        if (this.joinAssociationPath == null) {
            this.joinAssociationPath = this.buildNullExpression();
        }
        return this.joinAssociationPath;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return JoinFetch.queryBNF("fetch_join");
    }

    public boolean hasJoinAssociationPath() {
        return this.joinAssociationPath != null && !this.joinAssociationPath.isNull();
    }

    public boolean hasSpaceAfterFetch() {
        return this.hasSpaceAfterFetch;
    }

    public boolean isLeftJoinFetch() {
        String identifier = this.getIdentifier();
        return identifier == "LEFT JOIN FETCH" || identifier == "LEFT OUTER JOIN FETCH";
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
        this.hasSpaceAfterFetch = wordParser.skipLeadingWhitespace() > 0;
        this.joinAssociationPath = this.parse(wordParser, (JPQLQueryBNF)JoinFetch.queryBNF("join_association_path_expression*"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getIdentifier());
        if (this.hasSpaceAfterFetch) {
            writer.append(' ');
        }
        if (this.joinAssociationPath != null) {
            this.joinAssociationPath.toParsedText(writer, includeVirtual);
        }
    }
}

