/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.toc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.ui.wizards.toc.IRegisterTOCData;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocWizardMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RegisterTocOperation
extends WorkspaceModifyOperation {
    public static final String F_TOC_EXTENSION_POINT_ID = "org.eclipse.help.toc";
    public static final String F_HELP_EXTENSION_ID = "org.eclipse.help";
    public static final String F_TOC_ATTRIBUTE_FILE = "file";
    public static final String F_TOC_ATTRIBUTE_PRIMARY = "primary";
    public static final String F_TOC_ATTRIBUTE_EXTRADIR = "extradir";
    public static final String F_TOC_ATTRIBUTE_CATEGORY = "category";
    private IRegisterTOCData fPage;
    private Shell fShell;

    public RegisterTocOperation(IRegisterTOCData page, Shell shell) {
        this.fPage = page;
        this.fShell = shell;
    }

    public RegisterTocOperation(ISchedulingRule rule) {
        super(rule);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            boolean fragment = PluginRegistry.findModel((IProject)this.fPage.getPluginProject()).isFragmentModel();
            IFile file = this.fPage.getPluginProject().getFile(fragment ? ICoreConstants.FRAGMENT_PATH : ICoreConstants.PLUGIN_PATH);
            if (file.exists()) {
                this.modifyExistingPluginFile(file, monitor);
            } else {
                this.createNewPluginFile(file, monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void modifyExistingPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ua.ui", 4, TocWizardMessages.RegisterTocOperation_errorMessage1, null));
        }
        ModelModification mod = new ModelModification(this.fPage.getPluginProject()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterTocOperation.this.doModifyPluginModel(model, monitor);
                RegisterTocOperation.this.doModifyManifestModel(model);
            }
        };
        PDEModelUtility.modifyModel((ModelModification)mod, (IProgressMonitor)monitor);
    }

    private void doModifyPluginModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        FindTocExtensionResult result = this.findTocExtensionResult(modelBase);
        if (result.foundTocExtension() && result.foundExactTocElement()) {
            this.modifyExistingElement(result.fTocElement, monitor);
        } else if (result.foundTocExtension()) {
            this.modifyExistingExtension(result.fTocExtension, monitor);
        } else {
            this.insertNewExtension(modelBase, monitor);
        }
    }

    private void insertNewExtension(IPluginModelBase modelBase, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TocWizardMessages.RegisterTocOperation_task, 1);
        IPluginExtension extension = this.createExtensionToc(modelBase);
        modelBase.getPluginBase().add(extension);
        monitor.done();
    }

    private void modifyExistingExtension(IPluginExtension extension, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TocWizardMessages.RegisterTocOperation_task2, 1);
        this.createExtensionChildren(extension);
        monitor.done();
    }

    private void modifyExistingElement(IPluginElement tocElement, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TocWizardMessages.RegisterTocOperation_task3, 1);
        tocElement.setAttribute(F_TOC_ATTRIBUTE_FILE, this.fPage.getDataTocFile());
        boolean primary = this.fPage.getDataPrimary();
        if (primary || tocElement.getAttribute(F_TOC_ATTRIBUTE_PRIMARY) != null) {
            tocElement.setAttribute(F_TOC_ATTRIBUTE_PRIMARY, Boolean.toString(primary));
        }
        monitor.done();
    }

    private FindTocExtensionResult findTocExtensionResult(IPluginModelBase model) {
        FindTocExtensionResult result = new FindTocExtensionResult();
        IPluginExtension[] extensions = RegisterTocOperation.findTOCExtensions((ISharedExtensionsModel)model);
        int i = 0;
        while (i < extensions.length) {
            result.fTocExtension = extensions[i];
            if (extensions[i].getChildCount() != 0) {
                IPluginObject[] pluginObjects = extensions[i].getChildren();
                int j = 0;
                while (j < pluginObjects.length) {
                    IPluginAttribute fileAttribute;
                    IPluginElement element;
                    if (pluginObjects[j] instanceof IPluginElement && (element = (IPluginElement)pluginObjects[j]).getName().equals("toc") && (fileAttribute = element.getAttribute(F_TOC_ATTRIBUTE_FILE)) != null && PDETextHelper.isDefined((String)fileAttribute.getValue()) && this.fPage.getDataTocFile().equals(fileAttribute.getValue())) {
                        result.fTocElement = element;
                        return result;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static IPluginExtension[] findTOCExtensions(ISharedExtensionsModel model) {
        IPluginExtension[] extensions = model.getExtensions().getExtensions();
        ArrayList<IPluginExtension> tocExtensions = new ArrayList<IPluginExtension>();
        int i = 0;
        while (i < extensions.length) {
            String point = extensions[i].getPoint();
            if (F_TOC_EXTENSION_POINT_ID.equals(point)) {
                tocExtensions.add(extensions[i]);
            }
            ++i;
        }
        return tocExtensions.toArray(new IPluginExtension[tocExtensions.size()]);
    }

    private void createNewPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TocWizardMessages.RegisterTocOperation_task4, 4);
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)this.createModel(file);
        monitor.worked(1);
        IPluginBase base = model.getPluginBase();
        base.setSchemaVersion(TargetPlatformHelper.getSchemaVersion());
        base.add(this.createExtensionToc((IPluginModelBase)model));
        monitor.worked(1);
        model.save();
        monitor.worked(1);
        this.modifyExistingManifestFile(file);
        monitor.done();
    }

    private void modifyExistingManifestFile(IFile file) throws CoreException {
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ua.ui", 4, TocWizardMessages.RegisterTocOperation_errorMessage2, null));
        }
        ModelModification mod = new ModelModification(this.fPage.getPluginProject()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterTocOperation.this.doModifyManifestModel(model);
                RegisterTocOperation.this.doModifyBuildModel(model);
            }
        };
        PDEModelUtility.modifyModel((ModelModification)mod, null);
    }

    private void doModifyManifestModel(IBaseModel model) {
        RequireBundleHeader require;
        BundleSymbolicNameHeader symbolic;
        if (!(model instanceof IBundlePluginModelBase)) {
            return;
        }
        IBundlePluginModelBase modelBase = (IBundlePluginModelBase)model;
        IBundle bundle = modelBase.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
        if (header instanceof BundleSymbolicNameHeader && !(symbolic = (BundleSymbolicNameHeader)header).isSingleton()) {
            symbolic.setSingleton(true);
        }
        if ((header = bundle.getManifestHeader("Require-Bundle")) instanceof RequireBundleHeader && !(require = (RequireBundleHeader)header).hasElement(F_HELP_EXTENSION_ID)) {
            require.addBundle(F_HELP_EXTENSION_ID);
        }
    }

    private void doModifyBuildModel(IBaseModel model) throws CoreException {
        IBuildModel buildModel;
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        IBuild build = ClasspathUtilCore.getBuild((IPluginModelBase)modelBase);
        if (build == null) {
            return;
        }
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            return;
        }
        if (!entry.contains("plugin.xml")) {
            entry.addToken("plugin.xml");
        }
        if (build instanceof BuildObject && (buildModel = ((BuildObject)build).getModel()) instanceof WorkspaceBuildModel) {
            ((WorkspaceBuildModel)buildModel).save();
        }
    }

    private IPluginModelBase createModel(IFile file) {
        if (file.getProjectRelativePath().equals((Object)ICoreConstants.FRAGMENT_PATH)) {
            return new WorkspaceFragmentModel(file, false);
        }
        return new WorkspacePluginModel(file, false);
    }

    private IPluginExtension createExtensionToc(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint(F_TOC_EXTENSION_POINT_ID);
        this.createExtensionChildren(extension);
        return extension;
    }

    private void createExtensionChildren(IPluginExtension extension) throws CoreException {
        IPluginElement tocElement = this.createElementToc(extension);
        if (tocElement != null) {
            extension.add((IPluginObject)tocElement);
        }
    }

    private IPluginElement createElementToc(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("toc");
        element.setAttribute(F_TOC_ATTRIBUTE_FILE, this.fPage.getDataTocFile());
        boolean primary = this.fPage.getDataPrimary();
        if (primary) {
            element.setAttribute(F_TOC_ATTRIBUTE_PRIMARY, Boolean.TRUE.toString());
        } else {
            element.setAttribute(F_TOC_ATTRIBUTE_PRIMARY, Boolean.FALSE.toString());
        }
        return element;
    }

    private static class FindTocExtensionResult {
        public IPluginExtension fTocExtension = null;
        public IPluginElement fTocElement = null;

        public boolean foundTocExtension() {
            return this.fTocExtension != null;
        }

        public boolean foundExactTocElement() {
            return this.fTocElement != null;
        }
    }
}

