/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.ctxhelp;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class CtxHelpInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "ctxhelp-context";
    static /* synthetic */ Class class$0;

    public CtxHelpInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            CtxHelpModel model = new CtxHelpModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(file.getCharset());
            } else if (input instanceof IURIEditorInput) {
                IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
                model.setInstallLocation(store.getParent().getParent().toString());
                model.setCharset(this.getDefaultCharset());
            } else if (input instanceof JarEntryEditorInput) {
                JarEntryEditorInput jarEntryEditorInput = (JarEntryEditorInput)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file = (File)jarEntryEditorInput.getAdapter((Class)clazz);
                model.setInstallLocation(file.toString());
                model.setCharset(this.getDefaultCharset());
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
            return model;
        }
        return null;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }

    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }

    protected String getPartitionName() {
        return "___ctxhelp_partition";
    }
}

