/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.bugs.actions.Messages;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class NewTaskFromMarkerHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMarker[] markers = this.getSelectedMarkers(event);
        if (markers.length == 0 || markers[0] == null) {
            MessageDialog.openInformation(null, (String)Messages.NewTaskFromMarkerHandler_New_Task_from_Marker, (String)Messages.NewTaskFromMarkerHandler_No_marker_selected);
            return null;
        }
        final IMarker marker = markers[0];
        TaskMapping mapping = new TaskMapping(){

            public String getSummary() {
                StringBuilder sb = new StringBuilder();
                try {
                    MarkerType type = MarkerTypesModel.getInstance().getType(marker.getType());
                    sb.append(String.valueOf(type.getLabel()) + ": ");
                }
                catch (CoreException coreException) {}
                return String.valueOf(sb.toString()) + marker.getAttribute("message", "");
            }

            public String getDescription() {
                return NewTaskFromMarkerHandler.this.buildDescriptionFromMarkerItem(marker);
            }
        };
        TasksUiUtil.openNewTaskEditor((Shell)WorkbenchUtil.getShell(), (ITaskMapping)mapping, null);
        return null;
    }

    private String buildDescriptionFromMarkerItem(IMarker marker) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(Messages.NewTaskFromMarkerHandler_Resource_) + marker.getResource().getFullPath().removeLastSegments(1).toString().substring(1) + "/" + marker.getResource().getName());
        int lineNumber = marker.getAttribute("lineNumber", -1);
        if (lineNumber != -1) {
            sb.append(String.valueOf(Messages.NewTaskFromMarkerHandler_LOCATION_LINE) + lineNumber);
        }
        return sb.toString();
    }
}

