/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.WorkspaceMediator;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ILibraryChangeHandler;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagModelLoader;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TaglibFileTracker;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TaglibResourceManager;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.WebappConfiguration;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextParamSpecifiedFaceletTaglibLocator
extends AbstractFaceletTaglibLocator {
    private static final String ID = ContextParamSpecifiedFaceletTaglibLocator.class.getCanonicalName();
    private static final String DISPLAYNAME = Messages.ContextParamSpecifiedFaceletTaglibLocator_0;
    private final IProject _project;
    private final Map<String, IFaceletTagRecord> _records;
    private final TagRecordFactory _factory;
    private final TaglibResourceManager _fileManager;

    public ContextParamSpecifiedFaceletTaglibLocator(IProject project, TagRecordFactory factory, IModelProvider webAppProvider, AbstractVirtualComponentQuery vcQuery, WorkspaceMediator wsMediator) {
        super(ID, DISPLAYNAME);
        this._project = project;
        this._records = new HashMap<String, IFaceletTagRecord>();
        this._factory = factory;
        WebappConfiguration webConfig = new WebappConfiguration(project, webAppProvider, vcQuery, wsMediator);
        this._fileManager = new TaglibResourceManager(project, new LibraryChangeHandler(), wsMediator, webConfig);
    }

    public void start(IProject project) {
        this._fileManager.initResources();
        super.start((Object)project);
    }

    public void stop() {
        this._fileManager.dispose();
        super.stop();
    }

    @Override
    protected Map<String, ? extends IFaceletTagRecord> doLocate(IProject context) {
        List<IFile> files = this._fileManager.getResources();
        this._records.clear();
        for (IFile file : files) {
            if (!file.exists()) continue;
            TaglibFileTracker tracker = null;
            try {
                tracker = (TaglibFileTracker)this._fileManager.getInstance((IResource)file);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("Creating record", e);
            }
            IFaceletTagRecord record = this.createTagRecord(file);
            if (record == null) continue;
            this._records.put(record.getURI(), record);
            if (tracker == null) continue;
            tracker.setUri(record.getURI());
        }
        return this._records;
    }

    private IFaceletTagRecord createTagRecord(IFile file) {
        InputStream is = null;
        if (!file.isAccessible()) {
            return null;
        }
        try {
            is = file.getContents();
            TagModelLoader loader = new TagModelLoader(file.getFullPath().toFile().getCanonicalPath());
            loader.loadFromInputStream(is);
            FaceletTaglib taglib = loader.getTaglib();
            if (taglib != null && taglib.getNamespaceUri() != null && taglib.getNamespaceUri().trim().length() > 0) {
                IFaceletTagRecord iFaceletTagRecord = this._factory.createRecords(taglib, new IFaceletTagRecord.WorkspaceTagRecordDescriptor(file));
                return iFaceletTagRecord;
            }
        }
        catch (Exception e) {
            FaceletCorePlugin.log("Loading web root taglibs for project: " + this._project.getName(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    FaceletCorePlugin.log("Closing taglib.xml", e);
                }
            }
        }
        return null;
    }

    class LibraryChangeHandler
    implements ILibraryChangeHandler {
        LibraryChangeHandler() {
        }

        public void added(IFile file) {
            IFaceletTagRecord tagRecord = ContextParamSpecifiedFaceletTaglibLocator.this.createTagRecord(file);
            TaglibFileTracker tracker = null;
            try {
                tracker = (TaglibFileTracker)ContextParamSpecifiedFaceletTaglibLocator.this._fileManager.getInstance((IResource)file);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("Adding new library", e);
            }
            if (tagRecord != null) {
                ContextParamSpecifiedFaceletTaglibLocator.this._records.put(tagRecord.getURI(), tagRecord);
                if (tracker != null) {
                    tracker.setUri(tagRecord.getURI());
                }
                ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, null, tagRecord, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED));
            }
        }

        public void removed(String uri, IFile file) {
            IFaceletTagRecord tagRecord = (IFaceletTagRecord)ContextParamSpecifiedFaceletTaglibLocator.this._records.remove(uri);
            if (tagRecord != null) {
                ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, tagRecord, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED));
            }
        }

        public void changed(String uri, IFile file) {
            IFaceletTagRecord oldValue = (IFaceletTagRecord)ContextParamSpecifiedFaceletTaglibLocator.this._records.remove(uri);
            IFaceletTagRecord newValue = ContextParamSpecifiedFaceletTaglibLocator.this.createTagRecord(file);
            if (oldValue == null) {
                if (newValue != null) {
                    ContextParamSpecifiedFaceletTaglibLocator.this._records.put(uri, newValue);
                    ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, null, newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED));
                }
            } else if (newValue == null) {
                ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, oldValue, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED));
            } else {
                ContextParamSpecifiedFaceletTaglibLocator.this._records.put(uri, newValue);
                if (oldValue.getURI() != null && oldValue.getURI().equals(newValue.getURI())) {
                    ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, oldValue, newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.CHANGED));
                } else {
                    ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, oldValue, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED));
                    ContextParamSpecifiedFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, null, newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED));
                }
            }
        }
    }
}

