/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkStructConverter
extends JavaEclipseLinkConverter<EclipseLinkStructConverterAnnotation>
implements EclipseLinkStructConverter {
    private String converterClass;

    public JavaEclipseLinkStructConverter(JavaJpaContextNode parent, EclipseLinkStructConverterAnnotation converterAnnotation) {
        super(parent, converterAnnotation);
        this.converterClass = converterAnnotation.getConverter();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(((EclipseLinkStructConverterAnnotation)this.converterAnnotation).getConverter());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        ((EclipseLinkStructConverterAnnotation)this.converterAnnotation).setConverter(converterClass);
        this.setConverterClass_(converterClass);
    }

    protected void setConverterClass_(String converterClass) {
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    public Class<EclipseLinkStructConverter> getType() {
        return EclipseLinkStructConverter.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.converterClass != null) {
            this.validateConverterClass(messages, astRoot);
        }
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange(astRoot)));
        } else if (!this.converterClassExists(javaProject)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.converterClass}, this, this.getConverterClassTextRange(astRoot)));
        } else if (!this.converterClassImplementsInterface(javaProject, "org.eclipse.persistence.platform.database.converters.StructConverter")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "STRUCT_CONVERTER_CLASS_IMPLEMENTS_STRUCT_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange(astRoot)));
        }
    }

    private boolean converterClassExists(IJavaProject javaProject) {
        return this.converterClass != null && JDTTools.findType((IJavaProject)javaProject, (String)this.converterClass) != null;
    }

    private boolean converterClassImplementsInterface(IJavaProject javaProject, String interfaceName) {
        return this.converterClass != null && JDTTools.typeNamedImplementsInterfaceNamed((IJavaProject)javaProject, (String)this.converterClass, (String)interfaceName);
    }

    protected TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(((EclipseLinkStructConverterAnnotation)this.converterAnnotation).getConverterTextRange(astRoot), astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkStructConverter> getConverterType() {
            return EclipseLinkStructConverter.class;
        }

        @Override
        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.StructConverter";
        }

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation converterAnnotation, JavaJpaContextNode parent) {
            return new JavaEclipseLinkStructConverter(parent, (EclipseLinkStructConverterAnnotation)converterAnnotation);
        }
    }
}

