/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkCustomConverter
extends JavaEclipseLinkConverter<EclipseLinkConverterAnnotation>
implements EclipseLinkCustomConverter {
    private String converterClass;
    private String fullyQualifiedConverterClass;
    public static final String FULLY_QUALIFIED_CONVERTER_CLASS_PROPERTY = "fullyQualifiedConverterClass";

    public JavaEclipseLinkCustomConverter(JavaJpaContextNode parent, EclipseLinkConverterAnnotation converterAnnotation) {
        super(parent, converterAnnotation);
        this.converterClass = converterAnnotation.getConverterClass();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(((EclipseLinkConverterAnnotation)this.converterAnnotation).getConverterClass());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedConverterClass(((EclipseLinkConverterAnnotation)this.converterAnnotation).getFullyQualifiedConverterClassName());
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        ((EclipseLinkConverterAnnotation)this.converterAnnotation).setConverterClass(converterClass);
        this.setConverterClass_(converterClass);
    }

    protected void setConverterClass_(String converterClass) {
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    public String getFullyQualifiedConverterClass() {
        return this.fullyQualifiedConverterClass;
    }

    protected void setFullyQualifiedConverterClass(String converterClass) {
        String old = this.fullyQualifiedConverterClass;
        this.fullyQualifiedConverterClass = converterClass;
        this.firePropertyChanged(FULLY_QUALIFIED_CONVERTER_CLASS_PROPERTY, old, converterClass);
    }

    public Class<EclipseLinkCustomConverter> getType() {
        return EclipseLinkCustomConverter.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.converterClass != null) {
            this.validateConverterClass(messages, astRoot);
        }
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.converterClass == null) {
            return;
        }
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange(astRoot)));
        } else if (!((EclipseLinkConverterAnnotation)this.converterAnnotation).converterClassImplementsInterface("org.eclipse.persistence.mappings.converters.Converter", astRoot)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_IMPLEMENTS_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange(astRoot)));
        }
    }

    protected TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(((EclipseLinkConverterAnnotation)this.converterAnnotation).getConverterClassTextRange(astRoot), astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkCustomConverter> getConverterType() {
            return EclipseLinkCustomConverter.class;
        }

        @Override
        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Converter";
        }

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation converterAnnotation, JavaJpaContextNode parent) {
            return new JavaEclipseLinkCustomConverter(parent, (EclipseLinkConverterAnnotation)converterAnnotation);
        }
    }
}

