/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.model.value.AspectTreeValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.common.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.common.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeAspectAdapter<S extends Model, E>
extends AspectTreeValueModelAdapter<S, E> {
    protected final String[] treeNames;
    protected static final String[] EMPTY_TREE_NAMES = new String[0];
    protected final TreeChangeListener treeChangeListener;

    protected TreeAspectAdapter(String treeName, S subject) {
        this(new String[]{treeName}, subject);
    }

    protected TreeAspectAdapter(String[] treeNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), treeNames);
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... treeNames) {
        super(subjectHolder);
        this.treeNames = treeNames;
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> treeNames) {
        this(subjectHolder, treeNames.toArray(new String[treeNames.size()]));
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_TREE_NAMES);
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeAddEvent event) {
                TreeAspectAdapter.this.nodeAdded(event);
            }

            public void nodeRemoved(TreeRemoveEvent event) {
                TreeAspectAdapter.this.nodeRemoved(event);
            }

            public void treeCleared(TreeClearEvent event) {
                TreeAspectAdapter.this.treeCleared(event);
            }

            public void treeChanged(TreeChangeEvent event) {
                TreeAspectAdapter.this.treeChanged(event);
            }

            public String toString() {
                return "tree change listener: " + Arrays.asList(TreeAspectAdapter.this.treeNames);
            }
        };
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.subject).addTreeChangeListener(treeName, this.treeChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.subject).removeTreeChangeListener(treeName, this.treeChangeListener);
            ++n2;
        }
    }

    protected void nodeAdded(TreeAddEvent event) {
        this.fireNodeAdded(event.clone(this, "nodes"));
    }

    protected void nodeRemoved(TreeRemoveEvent event) {
        this.fireNodeRemoved(event.clone(this, "nodes"));
    }

    protected void treeCleared(TreeClearEvent event) {
        this.fireTreeCleared(event.clone(this, "nodes"));
    }

    protected void treeChanged(TreeChangeEvent event) {
        this.fireTreeChanged(event.clone(this, "nodes"));
    }
}

