/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;

public final class AWTListChangeListenerWrapper
implements ListChangeListener {
    private final ListChangeListener listener;

    public AWTListChangeListenerWrapper(ListChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(ListAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsAddedRunnable(event));
        }
    }

    public void itemsRemoved(ListRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsRemovedRunnable(event));
        }
    }

    public void itemsMoved(ListMoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsMoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsMovedRunnable(event));
        }
    }

    public void itemsReplaced(ListReplaceEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsReplaced_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsReplacedRunnable(event));
        }
    }

    public void listCleared(ListClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildListClearedRunnable(event));
        }
    }

    public void listChanged(ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildListChangedRunnable(event));
        }
    }

    private Runnable buildItemsAddedRunnable(final ListAddEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.itemsAdded_(event);
            }

            public String toString() {
                return "items added runnable";
            }
        };
    }

    private Runnable buildItemsRemovedRunnable(final ListRemoveEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.itemsRemoved_(event);
            }

            public String toString() {
                return "items removed runnable";
            }
        };
    }

    private Runnable buildItemsMovedRunnable(final ListMoveEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.itemsMoved_(event);
            }

            public String toString() {
                return "items moved runnable";
            }
        };
    }

    private Runnable buildItemsReplacedRunnable(final ListReplaceEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.itemsReplaced_(event);
            }

            public String toString() {
                return "items replaced runnable";
            }
        };
    }

    private Runnable buildListClearedRunnable(final ListClearEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.listCleared_(event);
            }

            public String toString() {
                return "list cleared runnable";
            }
        };
    }

    private Runnable buildListChangedRunnable(final ListChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTListChangeListenerWrapper.this.listChanged_(event);
            }

            public String toString() {
                return "list changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void itemsAdded_(ListAddEvent event) {
        this.listener.itemsAdded(event);
    }

    void itemsRemoved_(ListRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    void itemsMoved_(ListMoveEvent event) {
        this.listener.itemsMoved(event);
    }

    void itemsReplaced_(ListReplaceEvent event) {
        this.listener.itemsReplaced(event);
    }

    void listCleared_(ListClearEvent event) {
        this.listener.listCleared(event);
    }

    void listChanged_(ListChangeEvent event) {
        this.listener.listChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }
}

