/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterators;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationIterator<E1, E2>
implements Iterator<E2> {
    private final Iterator<? extends E1> iterator;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationIterator(Iterable<? extends E1> iterable) {
        this(iterable.iterator());
    }

    public TransformationIterator(Iterator<? extends E1> iterator) {
        this(iterator, Transformer.Disabled.instance());
    }

    public TransformationIterator(Iterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        this(iterable.iterator(), transformer);
    }

    public TransformationIterator(Iterator<? extends E1> iterator, Transformer<E1, ? extends E2> transformer) {
        this.iterator = iterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E2 next() {
        return this.transform(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    protected E2 transform(E1 next) {
        return this.transformer.transform(next);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterator);
    }
}

