/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterables;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeListIterable<E>
implements ListIterable<E> {
    private final ListIterable<? extends ListIterable<E>> iterables;

    public CompositeListIterable(List<ListIterable<E>> iterables) {
        this((ListIterable<ListIterable<E>>)new ListListIterable<ListIterable<E>>(iterables));
    }

    public CompositeListIterable(ListIterable<? extends ListIterable<E>> iterables) {
        this.iterables = iterables;
    }

    public CompositeListIterable(E object, List<E> list) {
        this(object, new ListListIterable<E>(list));
    }

    public CompositeListIterable(E object, ListIterable<E> iterable) {
        this(new ListIterable[]{new SingleElementListIterable<E>(object), iterable});
    }

    public CompositeListIterable(List<E> list, E object) {
        this(new ListListIterable<E>(list), object);
    }

    public CompositeListIterable(ListIterable<E> iterable, E object) {
        this(new ListIterable[]{iterable, new SingleElementListIterable<E>(object)});
    }

    public CompositeListIterable(ListIterable<E> ... iterables) {
        this((ListIterable<ListIterable<E>>)new ArrayListIterable<ListIterable<E>>(iterables));
    }

    public CompositeListIterable(List<E> ... lists) {
        this(new TransformationListIterable<List<E>, ListIterable<E>>(new ArrayListIterable<List<E>>(lists)){

            @Override
            protected ListIterable<E> transform(List<E> list) {
                return new ListListIterable(list);
            }
        });
    }

    @Override
    public ListIterator<E> iterator() {
        return new CompositeListIterator<E>(this.iterators());
    }

    protected ListIterator<? extends ListIterator<E>> iterators() {
        return new TransformationListIterator<ListIterable<E>, ListIterator<E>>(this.iterables()){

            @Override
            protected ListIterator<E> transform(ListIterable<E> next) {
                return next.iterator();
            }
        };
    }

    protected ListIterator<? extends ListIterable<E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterables);
    }
}

