/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebComponentArchiveLoadAdapter
extends ComponentArchiveLoadAdapter {
    public static IPath WEBLIB = new Path("/WEB-INF/lib");
    private Map<IPath, IResource> pathsToWorkbenchLibJars = new HashMap<IPath, IResource>();

    public WebComponentArchiveLoadAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public WebComponentArchiveLoadAdapter(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
    }

    @Override
    public List<IArchiveResource> getArchiveResources() {
        super.getArchiveResources();
        this.addLooseLibJARsToFiles();
        if (this.includeClasspathComponents) {
            this.addMappedClassFolders(IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_COMPONENT_PATH);
        }
        return this.filesHolder.getFiles();
    }

    public IVirtualReference[] getLibModules() {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        IVirtualReference[] refComponents = null;
        refComponents = !this.vComponent.isBinary() ? ((J2EEModuleVirtualComponent)this.vComponent).getNonManifestReferences() : this.vComponent.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            if (refComponents[i].getRuntimePath().equals((Object)WEBLIB)) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }

    public void addLooseLibJARsToFiles() {
        IVirtualReference[] libModules = this.getLibModules();
        int i = 0;
        while (i < libModules.length) {
            IVirtualReference iLibModule = libModules[i];
            IVirtualComponent looseComponent = iLibModule.getReferencedComponent();
            if (looseComponent.isBinary()) {
                File diskFile = (File)looseComponent.getAdapter(File.class);
                IPath uri = iLibModule.getRuntimePath().makeRelative().append("/" + diskFile.getName());
                this.addExternalFile(uri, diskFile);
            } else {
                String name = null;
                String archiveName = iLibModule.getArchiveName();
                name = archiveName != null && archiveName.length() > 0 ? archiveName : String.valueOf(looseComponent.getName()) + ".jar";
                String prefix = iLibModule.getRuntimePath().makeRelative().toString();
                if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
                    prefix = String.valueOf(prefix) + "/";
                }
                this.addClasspathComponentDependencies(looseComponent);
                String uri = String.valueOf(prefix) + name;
                try {
                    JavaComponentArchiveLoadAdapter archiveLoadAdapter = new JavaComponentArchiveLoadAdapter(looseComponent);
                    archiveLoadAdapter.setExportSource(this.isExportSource());
                    ArchiveOptions webLibOptions = new ArchiveOptions();
                    webLibOptions.setOption((Object)"LOAD_ADAPTER", (Object)archiveLoadAdapter);
                    IArchive webLibArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(webLibOptions);
                    webLibArchive.setPath((IPath)new Path(uri));
                    webLibArchive.setArchive(this.archive);
                    this.addFile(webLibArchive.getPath());
                    this.filesHolder.remove(webLibArchive.getPath());
                    this.filesHolder.addFile((IArchiveResource)webLibArchive);
                }
                catch (ArchiveOpenFailureException e) {
                    String message = ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.UNABLE_TO_LOAD_MODULE_ERROR_, new Object[]{uri, this.getComponent().getProject().getName(), e.getMessage()});
                    J2EEPlugin.logError(message);
                }
            }
            ++i;
        }
    }

    private void addFile(IPath deployPath) {
        IResource weblibJar = this.getWorkbenchResources(deployPath);
        if (weblibJar != null) {
            this.pathsToWorkbenchLibJars.put(deployPath, weblibJar);
        }
    }

    public IResource getWorkbenchLibJars(IPath deployPath) {
        return this.pathsToWorkbenchLibJars.get(deployPath);
    }

    private void addClasspathComponentDependencies(IVirtualComponent referencedComponent) {
        if (this.includeClasspathComponents && referencedComponent instanceof IClasspathDependencyProvider) {
            IVirtualReference[] cpRefs = ((IClasspathDependencyProvider)referencedComponent).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                IVirtualReference ref = cpRefs[j];
                IPath runtimePath = ref.getRuntimePath();
                if (ref.getReferencedComponent() instanceof IClasspathDependencyComponent && runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                    File cpEntryFile = (File)ref.getReferencedComponent().getAdapter(File.class);
                    this.addExternalFile((IPath)new Path("WEB-INF/lib/" + ref.getArchiveName()), cpEntryFile);
                }
                ++j;
            }
        }
    }

    @Override
    protected IPath getDefaultModelObjectPath() {
        return new Path("WEB-INF/web.xml");
    }
}

