/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.common.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.common.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.common.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorTreeItemContentProviderFactory
implements TreeItemContentProviderFactory {
    private Map<JaxbPlatformDescription, TreeItemContentProviderFactory> delegates = new HashMap<JaxbPlatformDescription, TreeItemContentProviderFactory>();

    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        TreeItemContentProviderFactory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildItemContentProvider(item, contentAndLabelProvider);
        }
        return null;
    }

    private TreeItemContentProviderFactory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JaxbContextNode contextNode = (JaxbContextNode)((IAdaptable)element).getAdapter(JaxbContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JaxbPlatformDescription platformDesc = contextNode.getJaxbProject().getPlatform().getDescription();
        if (this.delegates.containsKey(platformDesc)) {
            return this.delegates.get(platformDesc);
        }
        JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(platformDesc);
        TreeItemContentProviderFactory delegate = platformUi == null ? null : platformUi.getNavigatorUi().getTreeItemContentProviderFactory();
        this.delegates.put(platformDesc, delegate);
        return delegate;
    }
}

