/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public void sessionStarted() {
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return context instanceof JavaContentAssistInvocationContext ? this.computeCompletionProposals((JavaContentAssistInvocationContext)context) : Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            return this.computeCompletionProposals_(context);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ICompletionProposal> computeCompletionProposals_(JavaContentAssistInvocationContext context) {
        IContentType contentType;
        ICompilationUnit cu = context.getCompilationUnit();
        IFile file = cu != null ? this.getCorrespondingResource(cu) : null;
        IContentType iContentType = contentType = file != null ? PlatformTools.getContentType((IFile)file) : null;
        if (contentType == null || !contentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return Collections.emptyList();
        }
        JaxbProject jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)file.getProject());
        if (jaxbProject == null) {
            return Collections.emptyList();
        }
        Iterable javaNodes = jaxbProject.getPrimaryJavaNodes(cu);
        if (CollectionTools.isEmpty((Iterable)javaNodes)) {
            return Collections.emptyList();
        }
        CompletionContext cc = context.getCoreContext();
        char[] prefix = cc.getToken();
        Filter filter = prefix == null ? Filter.Null.instance() : new IgnoreCasePrefixFilter(prefix);
        int tokenStart = cc.getTokenStart();
        int tokenEnd = cc.getTokenEnd();
        if (tokenStart == -1) {
            return Collections.emptyList();
        }
        CompilationUnit astRoot = ASTTools.buildASTRoot((ICompilationUnit)cu);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (JavaContextNode javaNode : javaNodes) {
            for (String proposal : javaNode.getJavaCompletionProposals(context.getInvocationOffset(), filter, astRoot)) {
                proposals.add((ICompletionProposal)new CompletionProposal(proposal, tokenStart, tokenEnd - tokenStart + 1, proposal.length()));
            }
        }
        return proposals;
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJaxbUiPlugin.log(ex);
            return null;
        }
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreCasePrefixFilter
    implements Filter<String> {
        private final char[] prefix;

        IgnoreCasePrefixFilter(char[] prefix) {
            this.prefix = prefix;
        }

        public boolean accept(String s) {
            return StringTools.stringStartsWithIgnoreCase((char[])s.toCharArray(), (char[])this.prefix);
        }
    }
}

