/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposal(String name, IJavaScriptUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, relevance, image);
        this.fRewrite = rewrite;
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public ImportRewrite createImportRewrite(JavaScriptUnit astRoot) {
        this.fImportRewrite = StubUtility.createImportRewrite(astRoot, true);
        return this.fImportRewrite;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST();
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        if (this.fImportRewrite != null) {
            editRoot.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = JavaUIStatus.createError(4, "Rewriter not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

