/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityRowTableWizardSection;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EntityFieldsWizardPage
extends DataModelWizardPage {
    private Text entityNameText;
    private Text tableNameText;
    private Button tableNameCheckButton;
    private Button fieldAccessButton;
    private Button propertyAccessButton;
    private boolean isNonEntity = true;
    private boolean isButtonsCreated = false;

    public EntityFieldsWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(EntityWizardMsg.ENTITY_PROPERTIES_TITLE);
        this.setDescription(EntityWizardMsg.ENTITY_PROPERTIES_DESCRIPTION);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEntityDataModelProperties.ENTITY_FIELDS", "IEntityDataModelProperties.PK_FIELDS"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_entityPropertiesPage");
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 450;
        composite.setLayoutData((Object)data);
        composite.pack();
        this.entityNameText = this.createNameGroup(composite, EntityWizardMsg.ENTITY_NAME, "IEntityDataModelProperties.ENTITY_NAME");
        Group group = this.createGroup(composite, EntityWizardMsg.TABLE_NAME_GROUP);
        this.tableNameCheckButton = this.createCheckButton((Composite)group, EntityWizardMsg.USE_DEFAULT, "IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        this.tableNameText = this.createNameGroup((Composite)group, EntityWizardMsg.TABLE_NAME, "IEntityDataModelProperties.TABLE_NAME");
        this.tableNameText.setEnabled(!this.tableNameCheckButton.getSelection());
        this.isButtonsCreated = true;
        this.initNameGroup();
        this.createEntityFieldsGroup(composite);
        Group accessTypeGroup = this.createGroup(composite, EntityWizardMsg.ACCESS_TYPE);
        this.fieldAccessButton = this.createRadioButton((Composite)accessTypeGroup, EntityWizardMsg.FIELD_BASED, "IEntityDataModelProperties.FIELD_ACCESS_TYPE");
        this.propertyAccessButton = this.createRadioButton((Composite)accessTypeGroup, EntityWizardMsg.PROPERTY_BASED, "IEntityDataModelProperties.PROPERTY_ACCESS_TYPE");
        IStatus projectStatus = this.validateProjectName();
        if (!projectStatus.isOK()) {
            this.setErrorMessage(projectStatus.getMessage());
            composite.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected IStatus validateProjectName() {
        if (this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME") == null || this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").trim().length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)EntityWizardMsg.NO_JPA_PROJECTS);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected void createEntityFieldsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(1808);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(EntityWizardMsg.ENTITY_FIELDS_GROUP);
        new EntityRowTableWizardSection((Composite)group, this.model, "IEntityDataModelProperties.ENTITY_FIELDS");
    }

    protected Text createNameGroup(Composite parent, String label, String property) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label displayNameLabel = new Label(composite, 16384);
        displayNameLabel.setText(label);
        displayNameLabel.setLayoutData((Object)new GridData(32));
        Text nameText = new Text(composite, 2052);
        nameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(nameText, property, null);
        return nameText;
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(text);
        return group;
    }

    private Button createCheckButton(Composite parent, String text, String property) {
        final Button button = new Button(parent, 32);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = button.getSelection();
                if (EntityFieldsWizardPage.this.tableNameText != null) {
                    EntityFieldsWizardPage.this.tableNameText.setEnabled(!isChecked);
                }
            }
        });
        this.synchHelper.synchCheckbox(button, property, null);
        return button;
    }

    private Button createRadioButton(Composite parent, String text, String property) {
        Button button = new Button(parent, 16);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        this.synchHelper.synchRadio(button, property, null);
        return button;
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if ("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS".equals(propertyName)) {
            this.initNameGroup();
        }
        super.propertyChanged(event);
    }

    private void initNameGroup() {
        this.isNonEntity = this.model.getBooleanProperty("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        if (this.isButtonsCreated) {
            this.entityNameText.setEnabled(!this.isNonEntity);
            this.tableNameCheckButton.setEnabled(!this.isNonEntity);
            this.tableNameText.setEnabled(!this.tableNameCheckButton.getSelection());
        }
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }
}

