/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectJpaOrmMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.jpa.ui.internal.wizards.orm.MappingFileWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMakePersistentWizardPage
extends WizardPage {
    private static final int TABLE_HEIGHT = 250;
    private static final int TABLE_WIDTH = 300;
    private static String MAKE_PERSISTENT_PAGE_NAME = "MakePersistent";
    private TableViewer classTableViewer;
    private final String helpContextId;
    private final Type[] selectedTypes;
    private final JpaProject jpaProject;
    private JptResourceType jptResourceType;
    private final WritablePropertyValueModel<Boolean> annotateInJavaModel;
    private boolean isFirstCheck = true;
    private final WritablePropertyValueModel<String> mappingFileModel;
    private final WritablePropertyValueModel<Boolean> listInPersistenceXmlModel;

    protected JpaMakePersistentWizardPage(JpaProject jpaProject, List<IType> selectedTypes, String helpContextId) {
        super(MAKE_PERSISTENT_PAGE_NAME);
        this.jpaProject = jpaProject;
        this.selectedTypes = this.buildTypes(selectedTypes);
        this.jptResourceType = JptCommonCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
        this.helpContextId = helpContextId;
        this.annotateInJavaModel = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.mappingFileModel = new SimplePropertyValueModel();
        this.listInPersistenceXmlModel = new SimplePropertyValueModel((Object)(!this.jpaProject.discoversAnnotatedClasses() ? 1 : 0));
        this.setTitle(JptUiMessages.JpaMakePersistentWizardPage_title);
        this.setMessage(JptUiMessages.JpaMakePersistentWizardPage_message);
    }

    protected Type[] buildTypes(List<IType> selectedTypes) {
        return CollectionTools.list((Iterable)new TransformationIterable<IType, Type>(this.nonPersistentTypes(selectedTypes)){

            protected Type transform(IType jdtType) {
                return new Type(jdtType);
            }
        }).toArray(new Type[0]);
    }

    protected Iterable<IType> nonPersistentTypes(List<IType> selectedTypes) {
        return new FilteringIterable<IType>(selectedTypes){

            protected boolean accept(IType jdtType) {
                return JpaMakePersistentWizardPage.this.getJpaProject().getJpaFile((IFile)jdtType.getResource()).getRootStructureNodesSize() == 0;
            }
        };
    }

    protected JpaProject getJpaProject() {
        return this.jpaProject;
    }

    protected JpaPlatformUi getJpaPlatformUi() {
        String platformId = this.getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().getJpaPlatformUi(platformId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Button javaAnnotationButton = new Button(composite, 16);
        javaAnnotationButton.setText(JptUiMessages.JpaMakePersistentWizardPage_annotateInJavaRadioButton);
        javaAnnotationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.annotateInJavaModel.setValue((Object)Boolean.TRUE);
                JpaMakePersistentWizardPage.this.jptResourceType = JptCommonCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button mappingFileButton = new Button(composite, 16);
        mappingFileButton.setText(JptUiMessages.JpaMakePersistentWizardPage_mappingFileRadioButton);
        Composite mappingFileComposite = this.createMappingFileControl(composite);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        mappingFileComposite.setLayoutData((Object)data);
        mappingFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.annotateInJavaModel.setValue((Object)Boolean.FALSE);
                if (JpaMakePersistentWizardPage.this.isFirstCheck) {
                    JpaMakePersistentWizardPage.this.mappingFileModel.setValue((Object)JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
                    JpaMakePersistentWizardPage.this.isFirstCheck = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.classTableViewer = new TableViewer(composite, 68352);
        this.classTableViewer.getTable().setLinesVisible(true);
        this.classTableViewer.getTable().setHeaderVisible(true);
        this.classTableViewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.classTableViewer.setComparator((ViewerComparator)new TypeComparator());
        this.createTypeTableColumn();
        this.createMappingTableColumn();
        this.classTableViewer.setInput((Object)this.selectedTypes);
        data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.classTableViewer.getTable().setLayoutData((Object)data);
        Button persistenceXmlCheckBox = new Button(composite, 32);
        persistenceXmlCheckBox.setText(JptUiMessages.JpaMakePersistentWizardPage_listInPersistenceXmlCheckBox);
        SWTTools.bind(this.listInPersistenceXmlModel, (Button)persistenceXmlCheckBox);
        SWTTools.controlVisibleState(this.annotateInJavaModel, (Control[])new Control[]{persistenceXmlCheckBox});
        this.setControl((Control)composite);
        this.validate();
    }

    private Composite createMappingFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 10;
        composite.setLayout((Layout)layout);
        Link mappingFileLink = new Link(composite, 16384);
        mappingFileLink.setText(JptUiMessages.JpaMakePersistentWizardPage_mappingFileLink);
        mappingFileLink.setLayoutData((Object)new GridData(32));
        mappingFileLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.openNewMappingFileWizard();
            }
        });
        Text mappingFileText = this.createText(composite, 1);
        SWTTools.bind(this.mappingFileModel, (Text)mappingFileText);
        this.mappingFileModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                JpaXmlResource ormXmlResource = JpaMakePersistentWizardPage.this.getOrmXmlResource();
                if (ormXmlResource == null) {
                    JpaMakePersistentWizardPage.this.jptResourceType = JptJpaCorePlugin.ORM_XML_1_0_RESOURCE_TYPE;
                } else {
                    JpaMakePersistentWizardPage.this.jptResourceType = ormXmlResource.getResourceType();
                }
                JpaMakePersistentWizardPage.this.validate();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(JptUiMessages.JpaMakePersistentWizardPage_mappingFileBrowseButton);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.mappingFileBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTTools.controlEnabledState((PropertyValueModel)new ListInOrmMappingFileModel((PropertyValueModel<Boolean>)this.annotateInJavaModel), (Control[])new Control[]{mappingFileLink, mappingFileText, browseButton});
        return composite;
    }

    private Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gd);
        return text;
    }

    private void mappingFileBrowseButtonPressed() {
        ViewerFilter filter = this.buildMappingFileDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        SelectJpaOrmMappingFileDialog dialog = new SelectJpaOrmMappingFileDialog(this.getShell(), this.jpaProject.getProject(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(EntityWizardMsg.MAPPING_XML_TITLE);
        dialog.setMessage(EntityWizardMsg.CHOOSE_MAPPING_XML_MESSAGE);
        dialog.addFilter(filter);
        JpaXmlResource resource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(this.getMappingFileLocation()));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput(this.jpaProject.getProject());
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            this.mappingFileModel.setValue((Object)dialog.getChosenName());
            this.validate();
        }
    }

    protected ViewerFilter buildMappingFileDialogViewerFilter() {
        return new XmlMappingFileViewerFilter(this.jpaProject);
    }

    private void openNewMappingFileWizard() {
        IPath path = MappingFileWizard.createNewMappingFile((IStructuredSelection)new StructuredSelection((Object)this.jpaProject.getProject()), this.getMappingFileName());
        if (path != null) {
            this.mappingFileModel.setValue((Object)path.toString());
            this.validate();
        }
    }

    protected void createTypeTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptUiMessages.JpaMakePersistentWizardPage_typeTableColumn);
        column.setLabelProvider((CellLabelProvider)this.buildTypeColumnLabelProvider());
    }

    protected ColumnLabelProvider buildTypeColumnLabelProvider() {
        return new TypeColumnLabelProvider();
    }

    protected void createMappingTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptUiMessages.JpaMakePersistentWizardPage_mappingTableColumn);
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.classTableViewer){

            protected Object getValue(Object element) {
                return JpaMakePersistentWizardPage.this.getMappingUiDefinition(((Type)element).mappingKey);
            }

            protected void setValue(Object element, Object value) {
                ((Type)element).setMappingKey(((MappingUiDefinition)value).getKey());
                this.getViewer().update(element, null);
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)JpaMakePersistentWizardPage.this.classTableViewer.getControl());
                comboCellEditor.setLabelProvider((IBaseLabelProvider)JpaMakePersistentWizardPage.this.buildMappingComboCellEditorLabelProvider());
                comboCellEditor.setContentProvider(JpaMakePersistentWizardPage.this.buildMappingComboCellEditorContentProvider());
                comboCellEditor.setInput(element);
                return comboCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column.setLabelProvider((CellLabelProvider)this.buildMappingColumnLabelProvider());
    }

    protected ColumnLabelProvider buildMappingComboCellEditorLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((MappingUiDefinition)element).getLabel();
            }
        };
    }

    protected IStructuredContentProvider buildMappingComboCellEditorContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CollectionTools.collection(((Type)inputElement).typeMappingUiDefinitions()).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    protected ColumnLabelProvider buildMappingColumnLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                MappingUiDefinition<PersistentType, ?> mappingUiDefinition = JpaMakePersistentWizardPage.this.getMappingUiDefinition(((Type)element).mappingKey);
                return mappingUiDefinition.getLabel();
            }

            public Image getImage(Object element) {
                MappingUiDefinition<PersistentType, ?> mappingUiDefinition = JpaMakePersistentWizardPage.this.getMappingUiDefinition(((Type)element).mappingKey);
                return mappingUiDefinition.getImage();
            }
        };
    }

    protected MappingUiDefinition<? extends PersistentType, ?> getMappingUiDefinition(String mappingKey) {
        for (MappingUiDefinition<PersistentType, ?> provider : this.typeMappingUiDefinitions(this.jptResourceType)) {
            if (provider.getKey() != mappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException();
    }

    protected Iterable<String> typeMappingKeys(Iterable<? extends MappingUiDefinition<? extends PersistentType, ?>> mappingUiDefinitions) {
        return new TransformationIterable<MappingUiDefinition<? extends PersistentType, ?>, String>(mappingUiDefinitions){

            protected String transform(MappingUiDefinition<? extends PersistentType, ?> next) {
                return next.getKey();
            }
        };
    }

    protected Iterable<? extends MappingUiDefinition<? extends PersistentType, ?>> typeMappingUiDefinitions(JptResourceType jpaResourceType) {
        return CollectionTools.iterable(this.getJpaPlatformUi().typeMappingUiDefinitions(jpaResourceType));
    }

    protected void validate() {
        String errorMessage = null;
        if (this.selectedTypes.length == 0) {
            errorMessage = JptUiMessages.JpaMakePersistentWizardPage_selectedTypesPersistentError;
        } else if (this.isAddToOrmMappingFile()) {
            JpaXmlResource ormXmlResource = this.getOrmXmlResource();
            if (ormXmlResource == null) {
                errorMessage = JptUiMessages.JpaMakePersistentWizardPage_mappingFileDoesNotExistError;
            } else if (this.getJpaProject().getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                errorMessage = JptUiMessages.JpaMakePersistentWizardPage_mappingFileNotListedInPersistenceXmlError;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
    }

    protected void performFinish() {
        boolean modifiedPersistenceXml = false;
        Type[] typeArray = this.selectedTypes;
        int n = this.selectedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            modifiedPersistenceXml |= type.makePersistent();
            ++n2;
        }
        if (modifiedPersistenceXml) {
            try {
                this.getJpaProject().getPersistenceXmlResource().save(null);
            }
            catch (IOException iOException) {}
        }
    }

    protected JpaXmlResource getOrmXmlResource() {
        return this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.getMappingFileLocation()));
    }

    protected EntityMappings getEntityMappings() {
        JpaXmlResource xmlResource = this.getOrmXmlResource();
        return (EntityMappings)this.getJpaProject().getJpaFile(xmlResource.getFile()).getRootStructureNodes().iterator().next();
    }

    protected boolean isListInPersistenceXml() {
        return (Boolean)this.listInPersistenceXmlModel.getValue();
    }

    protected boolean isAnnotateInJavaModel() {
        return (Boolean)this.annotateInJavaModel.getValue();
    }

    protected boolean isAddToOrmMappingFile() {
        return !this.isAnnotateInJavaModel();
    }

    protected String getMappingFileLocation() {
        return (String)this.mappingFileModel.getValue();
    }

    protected String getMappingFileName() {
        return new File(this.getMappingFileLocation()).getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListInOrmMappingFileModel
    extends AspectPropertyValueModelAdapter<Boolean, Boolean> {
        ListInOrmMappingFileModel(PropertyValueModel<Boolean> annotateInJavaModel) {
            super(annotateInJavaModel);
        }

        protected Boolean buildValue_() {
            return (Boolean)this.subject == false;
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Type {
        private final IType jdtType;
        private String mappingKey;

        protected Type(IType jdtType) {
            this.jdtType = jdtType;
            this.mappingKey = "entity";
        }

        protected void setMappingKey(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        protected boolean makePersistent() {
            if (JpaMakePersistentWizardPage.this.isAnnotateInJavaModel()) {
                PersistenceUnit persistenceUnit = this.getPersistenceUnit();
                JavaResourcePersistentType persistentType = this.getJavaResourcePersistentType();
                persistentType.addAnnotation(this.getJavaTypeMappingDefinition(this.mappingKey).getAnnotationName());
                if (JpaMakePersistentWizardPage.this.isListInPersistenceXml() && persistenceUnit != null) {
                    persistenceUnit.addSpecifiedClassRef(persistentType.getQualifiedName());
                    return true;
                }
            } else {
                JpaXmlResource ormXmlResource = JpaMakePersistentWizardPage.this.getOrmXmlResource();
                final EntityMappings entityMappings = JpaMakePersistentWizardPage.this.getEntityMappings();
                ormXmlResource.modify(new Runnable(){

                    public void run() {
                        entityMappings.addPersistentType(Type.this.mappingKey, Type.this.jdtType.getFullyQualifiedName());
                    }
                });
            }
            return false;
        }

        protected Iterable<? extends MappingUiDefinition<? extends PersistentType, ?>> typeMappingUiDefinitions() {
            return CollectionTools.iterable(JpaMakePersistentWizardPage.this.getJpaPlatformUi().typeMappingUiDefinitions(JpaMakePersistentWizardPage.this.jptResourceType));
        }

        protected JavaTypeMappingDefinition getJavaTypeMappingDefinition(String key) {
            for (JavaTypeMappingDefinition definition : JpaMakePersistentWizardPage.this.getJpaProject().getJpaPlatform().getJavaTypeMappingDefinitions()) {
                if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
                return definition;
            }
            throw new IllegalArgumentException("Illegal type mapping key: " + key);
        }

        protected JavaResourcePersistentType getJavaResourcePersistentType() {
            return JpaMakePersistentWizardPage.this.getJpaProject().getJavaResourcePersistentType(this.jdtType.getFullyQualifiedName());
        }

        protected PersistenceUnit getPersistenceUnit() {
            Persistence p = this.getPersistence();
            if (p == null) {
                return null;
            }
            ListIterator units = p.persistenceUnits();
            return units.hasNext() ? (PersistenceUnit)units.next() : null;
        }

        protected Persistence getPersistence() {
            PersistenceXml pxml = this.getPersistenceXml();
            return pxml == null ? null : pxml.getPersistence();
        }

        protected PersistenceXml getPersistenceXml() {
            JpaRootContextNode rcn = JpaMakePersistentWizardPage.this.getJpaProject().getRootContextNode();
            return rcn == null ? null : rcn.getPersistenceXml();
        }
    }

    private final class TypeColumnLabelProvider
    extends ColumnLabelProvider {
        private final JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(2320);

        private TypeColumnLabelProvider() {
        }

        public String getText(Object element) {
            return this.javaElementLabelProvider.getText((Object)((Type)element).jdtType);
        }

        public Image getImage(Object element) {
            return this.javaElementLabelProvider.getImage((Object)((Type)element).jdtType);
        }
    }

    private final class TypeComparator
    extends ViewerComparator {
        private final JavaElementComparator javaElementComparator = new JavaElementComparator();

        private TypeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.javaElementComparator.compare(viewer, (Object)((Type)e1).jdtType, (Object)((Type)e2).jdtType);
        }
    }

    private final class TypeContentProvider
    implements IStructuredContentProvider {
        private TypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Type[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

