/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.ui.internal.details.BaseJoinColumnStateObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinColumnStateObject
extends BaseJoinColumnStateObject {
    private Boolean insertable;
    private Boolean nullable;
    private Boolean unique;
    private Boolean updatable;
    public static final String INSERTABLE_PROPERTY = "insertable";
    public static final String NULLABLE_PROPERTY = "nullable";
    public static final String UNIQUE_PROPERTY = "unique";
    public static final String UPDATABLE_PROPERTY = "updatable";

    public JoinColumnStateObject(Object owner, ReadOnlyJoinColumn joinColumn) {
        super(owner, (ReadOnlyBaseJoinColumn)joinColumn);
    }

    public boolean isDefaultInsertable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.isDefaultInsertable();
        }
        return true;
    }

    public boolean isDefaultNullable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.isDefaultNullable();
        }
        return true;
    }

    public boolean isDefaultUnique() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.isDefaultUnique();
        }
        return false;
    }

    public boolean isDefaultUpdatable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.isDefaultUpdatable();
        }
        return true;
    }

    public Boolean getInsertable() {
        return this.insertable;
    }

    public JoinColumn getJoinColumn() {
        return (JoinColumn)super.getJoinColumn();
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    protected void initialize(Object owner, ReadOnlyBaseJoinColumn baseJoinColumn) {
        super.initialize(owner, baseJoinColumn);
        if (baseJoinColumn != null) {
            ReadOnlyJoinColumn joinColumn = (ReadOnlyJoinColumn)baseJoinColumn;
            this.insertable = joinColumn.getSpecifiedInsertable();
            this.nullable = joinColumn.getSpecifiedNullable();
            this.unique = joinColumn.getSpecifiedUnique();
            this.updatable = joinColumn.getSpecifiedUpdatable();
        }
    }

    @Override
    protected String getInitialTable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn == null) {
            return null;
        }
        return joinColumn.getSpecifiedTable();
    }

    protected boolean isTableEditable() {
        return true;
    }

    public void setInsertable(Boolean insertable) {
        Boolean oldInsertable = this.insertable;
        this.insertable = insertable;
        this.firePropertyChanged(INSERTABLE_PROPERTY, oldInsertable, insertable);
    }

    public void setNullable(Boolean nullable) {
        Boolean oldNullable = this.nullable;
        this.nullable = nullable;
        this.firePropertyChanged(NULLABLE_PROPERTY, oldNullable, nullable);
    }

    public void setUnique(Boolean unique) {
        Boolean oldUnique = this.unique;
        this.unique = unique;
        this.firePropertyChanged(UNIQUE_PROPERTY, oldUnique, unique);
    }

    public void setUpdatable(Boolean updatable) {
        Boolean oldUpdatable = this.updatable;
        this.updatable = updatable;
        this.firePropertyChanged(UPDATABLE_PROPERTY, oldUpdatable, updatable);
    }

    @Override
    public ListIterator<String> tables() {
        return EmptyListIterator.instance();
    }

    @Override
    public void updateJoinColumn(BaseJoinColumn abstractJoinColumn) {
        String table;
        super.updateJoinColumn(abstractJoinColumn);
        JoinColumn joinColumn = (JoinColumn)abstractJoinColumn;
        if (this.isTableEditable() && this.valuesAreDifferent(table = this.getTable(), joinColumn.getSpecifiedTable())) {
            joinColumn.setSpecifiedTable(table);
        }
        if (joinColumn.getSpecifiedInsertable() != this.insertable) {
            joinColumn.setSpecifiedInsertable(this.insertable);
        }
        if (joinColumn.getSpecifiedUpdatable() != this.updatable) {
            joinColumn.setSpecifiedUpdatable(this.updatable);
        }
        if (joinColumn.getSpecifiedUnique() != this.unique) {
            joinColumn.setSpecifiedUnique(this.unique);
        }
        if (joinColumn.getSpecifiedNullable() != this.nullable) {
            joinColumn.setSpecifiedNullable(this.nullable);
        }
    }
}

