/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlElementRefAnnotation
extends SourceAnnotation<Attribute>
implements XmlElementRefAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElementRef");
    private String fullyQualifiedTypeName;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private final AnnotationElementAdapter<String> nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    private String name;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter = this.buildNamespaceDeclarationAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
    private String namespace;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter = this.buildTypeDeclarationAdapter();
    private final AnnotationElementAdapter<String> typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    private String type;

    public static SourceXmlElementRefAnnotation buildSourceXmlElementRefAnnotation(JavaResourceAttribute parent, Attribute attribute) {
        return new SourceXmlElementRefAnnotation((JavaResourceNode)parent, attribute, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceXmlElementRefAnnotation buildNestedSourceXmlElementRefAnnotation(JavaResourceNode parent, Attribute attribute, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceXmlElementRefAnnotation(parent, attribute, idaa);
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        this(parent, attribute, daa, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)attribute, daa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, Attribute attribute, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, attribute, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)attribute, idaa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, attribute, daa, annotationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeDeclarationAdapter() {
        return SourceXmlElementRefAnnotation.buildAnnotationElementAdapter(this.daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElementRef";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.type = this.buildType(astRoot);
        this.fullyQualifiedTypeName = this.buildFullyQualifiedTypeName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncType(this.buildType(astRoot));
        this.syncFullyQualifiedTypeName(this.buildFullyQualifiedTypeName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astRoot);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.attributeValueHasChanged(this.type, type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(CompilationUnit astRoot) {
        return (String)this.typeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    private void syncFullyQualifiedTypeName(String name) {
        String old = this.fullyQualifiedTypeName;
        this.fullyQualifiedTypeName = name;
        this.firePropertyChanged("fullyQualifiedTypeName", old, name);
    }

    private String buildFullyQualifiedTypeName(CompilationUnit astRoot) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astRoot));
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

