/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAnnotation<A extends AnnotatedElement>
extends SourceNode
implements org.eclipse.jpt.jaxb.core.resource.java.Annotation {
    protected final A annotatedElement;
    protected final DeclarationAnnotationAdapter daa;
    protected final AnnotationAdapter annotationAdapter;

    protected SourceAnnotation(JavaResourceNode parent, A annotatedElement, DeclarationAnnotationAdapter daa) {
        this(parent, annotatedElement, daa, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, daa));
    }

    protected SourceAnnotation(JavaResourceNode parent, A annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.annotatedElement = annotatedElement;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getAnnotationTextRange(astRoot);
    }

    @Override
    public Annotation getAstAnnotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    @Override
    public void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getAstAnnotation(astRoot));
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getAnnotationTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.textRangeTouches(this.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean textRangeTouches(TextRange textRange, int pos) {
        return textRange != null && textRange.touches(pos);
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astRoot));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AnnotationContainer<T extends NestableAnnotation>
    extends SourceNode.AnnotationContainer<T> {
        protected AnnotationContainer() {
            super(SourceAnnotation.this);
        }

        protected abstract String getAnnotationsPropertyName();

        @Override
        protected void fireItemAdded(int index, T addedItem) {
            SourceAnnotation.this.fireItemAdded(this.getAnnotationsPropertyName(), index, addedItem);
        }

        @Override
        protected void fireItemsRemoved(int index, List<T> removedItems) {
            SourceAnnotation.this.fireItemsRemoved(this.getAnnotationsPropertyName(), index, removedItems);
        }
    }
}

