/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementWrapper
extends AbstractJavaContextNode
implements XmlElementWrapper {
    protected final XmlElementWrapperAnnotation resourceXmlElementWrapper;
    protected String specifiedName;
    protected Boolean specifiedRequired;
    protected String specifiedNamespace;
    protected Boolean specifiedNillable;

    public GenericJavaXmlElementWrapper(JaxbAttributeMapping parent, XmlElementWrapperAnnotation resource) {
        super(parent);
        this.resourceXmlElementWrapper = resource;
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedNamespace = this.buildSpecifiedNamespace();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.specifiedNillable = this.buildSpecifiedNillable();
    }

    @Override
    public JaxbAttributeMapping getParent() {
        return (JaxbAttributeMapping)super.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getParent().getParent();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedNamespace_(this.buildSpecifiedNamespace());
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setSpecifiedNillable_(this.buildSpecifiedNillable());
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.getParent().getParent().getName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        this.resourceXmlElementWrapper.setName(name);
        this.setSpecifiedName_(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.resourceXmlElementWrapper.getName();
    }

    @Override
    public boolean isRequired() {
        return this.getSpecifiedRequired() == null ? this.isDefaultRequired() : this.getSpecifiedRequired().booleanValue();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.resourceXmlElementWrapper.setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        return this.resourceXmlElementWrapper.getRequired();
    }

    @Override
    public String getNamespace() {
        return this.getSpecifiedNamespace() == null ? this.getDefaultNamespace() : this.getSpecifiedNamespace();
    }

    @Override
    public String getDefaultNamespace() {
        return null;
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String newSpecifiedNamespace) {
        this.resourceXmlElementWrapper.setNamespace(newSpecifiedNamespace);
        this.setSpecifiedNamespace_(newSpecifiedNamespace);
    }

    protected void setSpecifiedNamespace_(String newSpecifiedNamespace) {
        String oldNamespace = this.specifiedNamespace;
        this.specifiedNamespace = newSpecifiedNamespace;
        this.firePropertyChanged("specifiedNamespace", oldNamespace, newSpecifiedNamespace);
    }

    protected String buildSpecifiedNamespace() {
        return this.resourceXmlElementWrapper.getNamespace();
    }

    @Override
    public boolean isNillable() {
        return this.getSpecifiedNillable() == null ? this.isDefaultNillable() : this.getSpecifiedNillable().booleanValue();
    }

    @Override
    public boolean isDefaultNillable() {
        return false;
    }

    @Override
    public Boolean getSpecifiedNillable() {
        return this.specifiedNillable;
    }

    @Override
    public void setSpecifiedNillable(Boolean newSpecifiedNillable) {
        this.resourceXmlElementWrapper.setNillable(newSpecifiedNillable);
        this.setSpecifiedNillable_(newSpecifiedNillable);
    }

    protected void setSpecifiedNillable_(Boolean newSpecifiedNillable) {
        Boolean oldNillable = this.specifiedNillable;
        this.specifiedNillable = newSpecifiedNillable;
        this.firePropertyChanged("specifiedNillable", oldNillable, newSpecifiedNillable);
    }

    protected Boolean buildSpecifiedNillable() {
        return this.resourceXmlElementWrapper.getNillable();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (!this.getPersistentAttribute().isJavaResourceAttributeTypeSubTypeOf(Collection.class.getName()) && !this.getPersistentAttribute().isJavaResourceAttributeTypeArray()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_WRAPPER_DEFINED_ON_NON_ARRAY_NON_COLLECTION", this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceXmlElementWrapper.getTextRange(astRoot);
    }
}

