/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbRegistry;
import org.eclipse.jpt.jaxb.core.context.JaxbTransientClass;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJaxbContextRoot
extends AbstractJaxbContextNode
implements JaxbContextRoot {
    protected final JaxbProject jaxbProject;
    protected final Map<String, JaxbPackage> packages;
    protected final Map<String, JaxbType> types;

    public AbstractJaxbContextRoot(JaxbProject jaxbProject) {
        super(null);
        if (jaxbProject == null) {
            throw new NullPointerException();
        }
        this.jaxbProject = jaxbProject;
        this.packages = new HashMap<String, JaxbPackage>();
        this.types = new HashMap<String, JaxbType>();
        this.initialize();
    }

    @Override
    public JaxbContextRoot getContextRoot() {
        return this;
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    protected void initialize() {
        HashSet totalTypes = CollectionTools.set((Object[])new String[0]);
        HashSet typesToScan = CollectionTools.set((Object[])new String[0]);
        for (String pkg : this.calculateInitialPackageNames()) {
            this.packages.put(pkg, this.buildPackage(pkg));
        }
        for (JavaResourceType registryResourceType : this.calculateRegistries()) {
            String className = registryResourceType.getQualifiedName();
            totalTypes.add(className);
            typesToScan.add(className);
            this.addType_(this.buildRegistry(registryResourceType));
        }
        Set<JavaResourceAbstractType> resourceTypesToProcess = this.calculateInitialPersistentTypes();
        while (!resourceTypesToProcess.isEmpty() || !typesToScan.isEmpty()) {
            for (JavaResourceAbstractType resourceType : new SnapshotCloneIterable(resourceTypesToProcess)) {
                String className = resourceType.getQualifiedName();
                totalTypes.add(className);
                typesToScan.add(className);
                JaxbType.Kind jaxbTypeKind = this.calculateJaxbTypeKind(resourceType);
                this.addType_(this.buildType(jaxbTypeKind, resourceType));
                resourceTypesToProcess.remove(resourceType);
            }
            for (String typeToScan : new SnapshotCloneIterable((Collection)typesToScan)) {
                JaxbType jaxbType = this.getType(typeToScan);
                if (jaxbType != null) {
                    for (String referencedTypeName : jaxbType.getDirectlyReferencedTypeNames()) {
                        JavaResourceAbstractType referencedType;
                        if (totalTypes.contains(referencedTypeName) || (referencedType = this.getJaxbProject().getJavaResourceType(referencedTypeName)) == null) continue;
                        resourceTypesToProcess.add(referencedType);
                    }
                }
                typesToScan.remove(typeToScan);
            }
        }
        for (String pkg : this.calculatePackageNames(totalTypes)) {
            if (this.packages.containsKey(pkg)) continue;
            this.packages.put(pkg, this.buildPackage(pkg));
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            jaxbPackage.synchronizeWithResourceModel();
        }
        for (JaxbType jaxbType : this.getTypes()) {
            jaxbType.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        HashSet packagesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet typesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet packagesToRemove = CollectionTools.set(this.packages.keySet());
        HashSet typesToRemove = CollectionTools.set(this.types.keySet());
        HashSet totalTypes = CollectionTools.set((Object[])new String[0]);
        HashSet typesToScan = CollectionTools.set((Object[])new String[0]);
        for (String pkg : this.calculateInitialPackageNames()) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        for (JavaResourceType registryResourceType : this.calculateRegistries()) {
            String className = registryResourceType.getQualifiedName();
            typesToRemove.remove(className);
            totalTypes.add(className);
            typesToScan.add(className);
            if (this.types.containsKey(className)) {
                if (this.types.get(className).getKind() == JaxbType.Kind.REGISTRY) {
                    typesToUpdate.add(className);
                    continue;
                }
                this.removeType(className);
                this.addType(this.buildRegistry(registryResourceType));
                continue;
            }
            this.addType(this.buildRegistry(registryResourceType));
        }
        Set<JavaResourceAbstractType> resourceTypesToProcess = this.calculateInitialPersistentTypes();
        while (!resourceTypesToProcess.isEmpty() || !typesToScan.isEmpty()) {
            for (JavaResourceAbstractType resourceType : new SnapshotCloneIterable(resourceTypesToProcess)) {
                String className = resourceType.getQualifiedName();
                typesToRemove.remove(className);
                totalTypes.add(className);
                typesToScan.add(className);
                this.processType(resourceType, typesToUpdate);
                resourceTypesToProcess.remove(resourceType);
            }
            for (String typeToScan : new SnapshotCloneIterable((Collection)typesToScan)) {
                JaxbType jaxbType = this.getType(typeToScan);
                if (jaxbType != null) {
                    for (String referencedTypeName : jaxbType.getDirectlyReferencedTypeNames()) {
                        JavaResourceAbstractType referencedType;
                        if (StringTools.stringIsEmpty((String)referencedTypeName) || totalTypes.contains(referencedTypeName) || (referencedType = this.getJaxbProject().getJavaResourceType(referencedTypeName)) == null) continue;
                        resourceTypesToProcess.add(referencedType);
                    }
                }
                typesToScan.remove(typeToScan);
            }
        }
        for (String pkg : this.calculatePackageNames(totalTypes)) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        for (String packageToUpdate : packagesToUpdate) {
            this.packages.get(packageToUpdate).update();
        }
        for (String typeToUpdate : typesToUpdate) {
            this.types.get(typeToUpdate).update();
        }
        for (String packageToRemove : packagesToRemove) {
            this.removePackage(packageToRemove);
        }
        for (String typeToRemove : typesToRemove) {
            this.removeType(typeToRemove);
        }
    }

    protected Set<String> calculateInitialPackageNames() {
        return CollectionTools.set((Iterable)new TransformationIterable<JavaResourcePackage, String>(this.getJaxbProject().getAnnotatedJavaResourcePackages()){

            protected String transform(JavaResourcePackage o) {
                return o.getName();
            }
        });
    }

    protected Set<String> calculatePackageNames(Set<String> typeNames) {
        HashSet packageNames = CollectionTools.set((Object[])new String[0]);
        for (String typeName : typeNames) {
            JaxbType jaxbType = this.types.get(typeName);
            if (jaxbType == null) continue;
            packageNames.add(jaxbType.getPackageName());
        }
        return packageNames;
    }

    protected Set<JavaResourceType> calculateRegistries() {
        return CollectionTools.set((Iterable)new SubIterableWrapper((Iterable)new FilteringIterable<JavaResourceAbstractType>(this.getJaxbProject().getJavaSourceResourceTypes()){

            protected boolean accept(JavaResourceAbstractType o) {
                return o.getKind() == JavaResourceAbstractType.Kind.TYPE && o.getAnnotation("javax.xml.bind.annotation.XmlRegistry") != null;
            }
        }));
    }

    protected Set<JavaResourceAbstractType> calculateInitialPersistentTypes() {
        HashSet set = CollectionTools.set((Iterable)new FilteringIterable<JavaResourceAbstractType>(this.getJaxbProject().getJavaSourceResourceTypes()){

            protected boolean accept(JavaResourceAbstractType o) {
                return o.getAnnotation("javax.xml.bind.annotation.XmlType") != null && o.getAnnotation("javax.xml.bind.annotation.XmlRegistry") == null;
            }
        });
        CollectionTools.addAll((Collection)set, (Iterable)new FilteringIterable((Iterable)new TransformationIterable<String, JavaResourceAbstractType>((Iterable)new CompositeIterable((Iterable)new TransformationIterable<JaxbIndexResource, Iterable<String>>(this.getJaxbProject().getJaxbIndexResources()){

            protected Iterable<String> transform(JaxbIndexResource o) {
                return o.getFullyQualifiedClassNames();
            }
        })){

            protected JavaResourceAbstractType transform(String o) {
                return AbstractJaxbContextRoot.this.getJaxbProject().getJavaResourceType(o);
            }
        }, NotNullFilter.instance()));
        return set;
    }

    protected void processType(JavaResourceAbstractType resourceType, Set<String> typesToUpdate) {
        JaxbType.Kind jaxbTypeKind = this.calculateJaxbTypeKind(resourceType);
        String className = resourceType.getQualifiedName();
        if (this.types.containsKey(className)) {
            if (this.types.get(className).getKind() == jaxbTypeKind) {
                typesToUpdate.add(className);
                return;
            }
            this.removeType(className);
        }
        this.addType(this.buildType(jaxbTypeKind, resourceType));
    }

    protected JaxbType.Kind calculateJaxbTypeKind(JavaResourceAbstractType resourceType) {
        if (resourceType.getKind() == JavaResourceAbstractType.Kind.ENUM) {
            return JaxbType.Kind.PERSISTENT_ENUM;
        }
        if (resourceType.getAnnotation("javax.xml.bind.annotation.XmlRegistry") != null) {
            return JaxbType.Kind.REGISTRY;
        }
        if (resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient") != null) {
            return JaxbType.Kind.TRANSIENT;
        }
        return JaxbType.Kind.PERSISTENT_CLASS;
    }

    protected JaxbType buildType(JaxbType.Kind jaxbTypeKind, JavaResourceAbstractType resourceType) {
        if (jaxbTypeKind == JaxbType.Kind.PERSISTENT_ENUM) {
            return this.buildPersistentEnum((JavaResourceEnum)resourceType);
        }
        if (jaxbTypeKind == JaxbType.Kind.REGISTRY) {
            return this.buildRegistry((JavaResourceType)resourceType);
        }
        if (jaxbTypeKind == JaxbType.Kind.TRANSIENT) {
            return this.buildTransientClass((JavaResourceType)resourceType);
        }
        return this.buildPersistentClass((JavaResourceType)resourceType);
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this.jaxbProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jaxbProject.getProject();
    }

    @Override
    public Iterable<JaxbPackage> getPackages() {
        return new LiveCloneIterable(this.packages.values());
    }

    @Override
    public int getPackagesSize() {
        return this.packages.size();
    }

    @Override
    public JaxbPackage getPackage(String packageName) {
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            if (!StringTools.stringsAreEqual((String)jaxbPackage.getName(), (String)packageName)) continue;
            return jaxbPackage;
        }
        return null;
    }

    protected JaxbPackage addPackage(JaxbPackage contextPackage) {
        if (this.packages.containsKey(contextPackage.getName())) {
            throw new IllegalArgumentException("Package with that name already exists.");
        }
        this.packages.put(contextPackage.getName(), contextPackage);
        this.fireItemAdded("packages", contextPackage);
        return contextPackage;
    }

    protected void removePackage(JaxbPackage contextPackage) {
        this.removePackage(contextPackage.getName());
    }

    protected void removePackage(String packageName) {
        if (!this.packages.containsKey(packageName)) {
            throw new IllegalArgumentException("No package with that name exists.");
        }
        JaxbPackage removedPackage = this.packages.remove(packageName);
        this.fireItemRemoved("packages", removedPackage);
    }

    protected JaxbPackage buildPackage(String packageName) {
        return this.getFactory().buildPackage(this, packageName);
    }

    protected boolean isEmpty(JaxbPackage jaxbPackage) {
        return jaxbPackage.isEmpty();
    }

    @Override
    public Iterable<JaxbType> getTypes() {
        return new LiveCloneIterable(this.types.values());
    }

    @Override
    public int getTypesSize() {
        return this.types.size();
    }

    @Override
    public JaxbType getType(String typeName) {
        return this.types.get(typeName);
    }

    protected void addType_(JaxbType type) {
        this.types.put(type.getFullyQualifiedName(), type);
    }

    protected void addType(JaxbType type) {
        if (this.types.containsKey(type.getFullyQualifiedName())) {
            throw new IllegalArgumentException("Type with that name already exists.");
        }
        this.addType_(type);
        this.fireItemAdded("types", type);
    }

    protected void removeType(JaxbType type) {
        this.removeType(type.getFullyQualifiedName());
    }

    protected void removeType(String typeName) {
        if (!this.types.containsKey(typeName)) {
            throw new IllegalArgumentException("No type with that name exists.");
        }
        JaxbType removedType = this.types.remove(typeName);
        this.fireItemRemoved("types", removedType);
    }

    @Override
    public Iterable<JaxbType> getTypes(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public Iterable<JaxbRegistry> getRegistries() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.REGISTRY;
            }
        });
    }

    protected JaxbRegistry buildRegistry(JavaResourceType resourceType) {
        return this.getFactory().buildRegistry(this, resourceType);
    }

    @Override
    public Iterable<JaxbRegistry> getRegistries(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbRegistry>(this.getRegistries()){

            protected boolean accept(JaxbRegistry o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public Iterable<JaxbTransientClass> getTransientClasses() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.TRANSIENT;
            }
        });
    }

    protected JaxbTransientClass buildTransientClass(JavaResourceType resourceType) {
        return this.getFactory().buildJavaTransientClass(this, resourceType);
    }

    @Override
    public Iterable<JaxbTransientClass> getTransientClasses(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbTransientClass>(this.getTransientClasses()){

            protected boolean accept(JaxbTransientClass o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public JaxbTransientClass getTransientClass(String className) {
        for (JaxbTransientClass jaxbClass : this.getTransientClasses()) {
            if (!StringTools.stringsAreEqual((String)jaxbClass.getFullyQualifiedName(), (String)className)) continue;
            return jaxbClass;
        }
        return null;
    }

    @Override
    public Iterable<JaxbPersistentClass> getPersistentClasses() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.PERSISTENT_CLASS;
            }
        });
    }

    protected JaxbPersistentClass buildPersistentClass(JavaResourceType resourceType) {
        return this.getFactory().buildJavaPersistentClass(this, resourceType);
    }

    @Override
    public Iterable<JaxbPersistentClass> getPersistentClasses(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbPersistentClass>(this.getPersistentClasses()){

            protected boolean accept(JaxbPersistentClass o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public JaxbPersistentClass getPersistentClass(String className) {
        for (JaxbPersistentClass jaxbClass : this.getPersistentClasses()) {
            if (!StringTools.stringsAreEqual((String)jaxbClass.getFullyQualifiedName(), (String)className)) continue;
            return jaxbClass;
        }
        return null;
    }

    @Override
    public JaxbClass getClass(String fullyQualifiedTypeName) {
        JaxbPersistentClass jaxbClass = this.getPersistentClass(fullyQualifiedTypeName);
        return jaxbClass != null ? jaxbClass : this.getTransientClass(fullyQualifiedTypeName);
    }

    @Override
    public Iterable<JaxbPersistentEnum> getPersistentEnums() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.PERSISTENT_ENUM;
            }
        });
    }

    protected JaxbPersistentEnum buildPersistentEnum(JavaResourceEnum resourceEnum) {
        return this.getFactory().buildJavaPersistentEnum(this, resourceEnum);
    }

    @Override
    public Iterable<JaxbPersistentEnum> getPersistentEnums(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbPersistentEnum>(this.getPersistentEnums()){

            protected boolean accept(JaxbPersistentEnum o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public JaxbPersistentEnum getPersistentEnum(String enumName) {
        for (JaxbPersistentEnum jaxbEnum : this.getPersistentEnums()) {
            if (!StringTools.stringsAreEqual((String)jaxbEnum.getFullyQualifiedName(), (String)enumName)) continue;
            return jaxbEnum;
        }
        return null;
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.jaxbProject.stateChanged();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        for (JaxbPackage pkg : this.packages.values()) {
            pkg.validate(messages, reporter);
        }
        for (JaxbType type : this.types.values()) {
            type.validate(messages, reporter);
        }
    }
}

