/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import java.util.HashMap;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewPageContentProvider;

public class CalleesContentProvider
extends DependenciesViewPageContentProvider {
    private BundleDescription fFragmentDescription;

    public CalleesContentProvider(DependenciesView view) {
        super(view);
    }

    protected Object[] findCallees(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return new Object[0];
        }
        this.fFragmentDescription = null;
        HostSpecification spec = desc.getHost();
        if (spec != null) {
            this.fFragmentDescription = desc;
            Object[] fragmentDependencies = this.getDependencies(desc);
            BaseDescription host = spec.getSupplier();
            if (host instanceof BundleDescription) {
                BundleDescription hostDesc = (BundleDescription)host;
                int i = 0;
                while (i < fragmentDependencies.length) {
                    ExportPackageDescription epd;
                    BundleDescription dependency = null;
                    if (fragmentDependencies[i] instanceof BundleSpecification) {
                        dependency = ((BundleSpecification)fragmentDependencies[i]).getBundle();
                    } else if (fragmentDependencies[i] instanceof ImportPackageSpecification && (epd = (ExportPackageDescription)((ImportPackageSpecification)fragmentDependencies[i]).getSupplier()) != null) {
                        dependency = epd.getSupplier();
                    }
                    if (dependency != null && dependency.equals(hostDesc)) {
                        return fragmentDependencies;
                    }
                    ++i;
                }
                Object[] result = new Object[fragmentDependencies.length + 1];
                result[0] = hostDesc;
                System.arraycopy(fragmentDependencies, 0, result, 1, fragmentDependencies.length);
                return result;
            }
            return fragmentDependencies;
        }
        return this.getDependencies(desc);
    }

    protected Object[] findCallees(BundleDescription desc) {
        if (desc == null) {
            return new Object[0];
        }
        return this.getDependencies(desc);
    }

    private Object[] getDependencies(BundleDescription desc) {
        HashMap<Object, Object> dependencies = new HashMap<Object, Object>();
        BundleSpecification[] requiredBundles = desc.getRequiredBundles();
        int i = 0;
        while (i < requiredBundles.length) {
            BaseDescription bd = requiredBundles[i].getSupplier();
            if (bd != null) {
                dependencies.put(bd, requiredBundles[i]);
            } else {
                dependencies.put(requiredBundles[i], requiredBundles[i]);
            }
            ++i;
        }
        ImportPackageSpecification[] importedPkgs = desc.getImportPackages();
        int i2 = 0;
        while (i2 < importedPkgs.length) {
            BundleDescription exporter;
            BaseDescription bd = importedPkgs[i2].getSupplier();
            if (bd != null && bd instanceof ExportPackageDescription && (exporter = ((ExportPackageDescription)bd).getExporter()) != null) {
                Object obj = dependencies.get(exporter);
                if (obj == null) {
                    dependencies.put(exporter, importedPkgs[i2]);
                } else if (!"optional".equals(importedPkgs[i2].getDirective("resolution")) && obj instanceof ImportPackageSpecification && "optional".equals(((ImportPackageSpecification)obj).getDirective("resolution"))) {
                    dependencies.put(exporter, importedPkgs[i2]);
                }
            }
            ++i2;
        }
        BundleDescription[] frags = desc.getFragments();
        int i3 = 0;
        while (i3 < frags.length) {
            if (!frags[i3].equals(this.fFragmentDescription)) {
                dependencies.put(frags[i3], frags[i3]);
            }
            ++i3;
        }
        return dependencies.values().toArray();
    }
}

