/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public abstract class AbstractFoldingStructureProvider
implements IFoldingStructureProvider,
IModelChangedListener {
    private PDESourcePage fEditor;
    private IEditingModel fModel;
    static /* synthetic */ Class class$0;

    public AbstractFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        this.fEditor = editor;
        this.fModel = model;
    }

    public void update() {
        ProjectionAnnotationModel annotationModel;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((annotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter(clazz)) == null) {
            return;
        }
        HashSet currentRegions = new HashSet();
        try {
            this.addFoldingRegions(currentRegions, this.fModel);
            this.updateFoldingRegions(annotationModel, currentRegions);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void updateFoldingRegions(ProjectionAnnotationModel model, Set currentRegions) {
        Annotation[] deletions = this.computeDifferences(model, currentRegions);
        HashMap additionsMap = new HashMap();
        Iterator iter = currentRegions.iterator();
        while (iter.hasNext()) {
            Object position = iter.next();
            additionsMap.put(new ProjectionAnnotation(false), position);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Set additions) {
        ArrayList deletions = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition((Annotation)annotation);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    public void initialize() {
        this.update();
    }

    public void modelChanged(IModelChangedEvent event) {
        this.update();
    }

    public void reconciled(IDocument document) {
        this.update();
    }
}

