/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class InMemoryCompiler {
    static final Iterable<String> OPTIONS = Arrays.asList("-g:source,lines,vars");
    protected String targetFileName;
    protected JavaCompiler compiler;
    protected DiagnosticCollector<JavaFileObject> diagnosticsCollector;
    protected JavaFileManager fileManager;

    public InMemoryCompiler(String targetFileName) {
        this.targetFileName = targetFileName;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.diagnosticsCollector = new DiagnosticCollector();
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public DiagnosticCollector<JavaFileObject> getDiagnosticsCollector() {
        return this.diagnosticsCollector;
    }

    public byte[] compile(CharSequence source) {
        JavaSourceFromString targetSource = new JavaSourceFromString(this.targetFileName, ((Object)source).toString());
        ByteArrayJavaFileObject targetClass = new ByteArrayJavaFileObject(this.targetFileName);
        List<JavaFileObject> compilationUnits = Arrays.asList(targetSource);
        ByteArrayFileManager bafm = new ByteArrayFileManager(this.compiler.getStandardFileManager(null, null, null), targetClass);
        StringWriter sw = new StringWriter();
        JavaCompiler.CompilationTask task = this.compiler.getTask(sw, bafm, this.diagnosticsCollector, OPTIONS, null, compilationUnits);
        task.call();
        return targetClass.toByteArray();
    }

    class ByteArrayFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        ByteArrayJavaFileObject bajfo;

        ByteArrayFileManager(StandardJavaFileManager sjfm, ByteArrayJavaFileObject bajfo) {
            super(sjfm);
            this.bajfo = bajfo;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return this.bajfo;
        }
    }

    class ByteArrayJavaFileObject
    extends SimpleJavaFileObject {
        ByteArrayOutputStream bos;

        public ByteArrayJavaFileObject(String name) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.bos = new ByteArrayOutputStream();
        }

        public byte[] toByteArray() {
            return this.bos.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }
    }

    class JavaSourceFromString
    extends SimpleJavaFileObject {
        CharSequence source;

        JavaSourceFromString(String name, CharSequence source) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }
}

