/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.JavaResourceChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.resources.WebContentChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.CommandLineUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.SpringUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaCommand
extends AbstractDataModelOperation {
    public static final String CXF_TOOL_CLASS_NAME = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    private WSDL2JavaDataModel model;
    private IWebService ws;
    private JavaResourceChangeListener javaResourceChangeListener;
    private WebContentChangeListener webContentChangeListener;

    public WSDL2JavaCommand(WSDL2JavaDataModel model, IWebService ws) {
        this.model = model;
        this.ws = ws;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.javaResourceChangeListener = new JavaResourceChangeListener((IPath)new Path(this.model.getJavaSourceFolder()));
        this.webContentChangeListener = new WebContentChangeListener(this.model.getProjectName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContentChangeListener, 1);
        String projectName = this.model.getProjectName();
        this.ws.getWebServiceInfo().setImplURLs(new String[]{String.valueOf(projectName) + "/Impl.java"});
        String[] progArgs = CommandLineUtils.getWSDL2JavaProgramArguments((WSDL2JavaDataModel)this.model);
        try {
            try {
                IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
                LaunchUtils.launch((IJavaProject)javaProject, (String)CXF_TOOL_CLASS_NAME, (String[])progArgs);
                FileUtils.copyW2JFilesFromTmp((WSDL2JavaDataModel)this.model);
                if (this.model.isGenerateImplementation()) {
                    SpringUtils.createConfigurationFromWSDL((WSDL2JavaDataModel)this.model);
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
            }
            catch (IOException ioe) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ioe.getLocalizedMessage());
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
            }
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
            FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.javaResourceChangeListener.getChangedResources());
        changedResources.addAll(this.webContentChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFCreationCorePlugin.log(status);
                }
            }
        }
        return status;
    }

    public CXFDataModel getCXFDataModel() {
        return this.model;
    }

    public void setJavaSourceFolder(String javaSourceFolder) {
        this.model.setJavaSourceFolder(javaSourceFolder);
    }

    public void setServiceName(String serviceName) {
        this.model.setServiceName(serviceName);
    }

    public void setGenerateServer(boolean generateServer) {
        this.model.setGenerateServer(generateServer);
    }

    public void setGenerateImplementation(boolean generateImplementation) {
        this.model.setGenerateImplementation(generateImplementation);
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.model.setUseDefaultValues(useDefaultValues);
    }

    public void setProcessSOAPHeaders(boolean processSOAPHeaders) {
        this.model.setProcessSOAPHeaders(processSOAPHeaders);
    }

    public void setLoadDefaultNamespacePackageNameMapping(boolean loadDefaultNamespacePackageNameMapping) {
        this.model.setLoadDefaultNamespacePackageNameMapping(loadDefaultNamespacePackageNameMapping);
    }

    public void setLoadDefaultExcludesNamepsaceMapping(boolean loadDefaultExcludesNamepsaceMapping) {
        this.model.setLoadDefaultExcludesNamepsaceMapping(loadDefaultExcludesNamepsaceMapping);
    }

    public void setAutoNameResolution(boolean autoNameResolution) {
        this.model.setAutoNameResolution(autoNameResolution);
    }

    public void setXjcUseDefaultValues(boolean xjcUseDefaultValues) {
        this.model.setXjcUseDefaultValues(xjcUseDefaultValues);
    }

    public void setXjcToString(boolean xjcToString) {
        this.model.setXjcToStringSimple(xjcToString);
    }

    public void setXjcToStringSimple(boolean xjcToStringSimple) {
        this.model.setXjcToStringSimple(xjcToStringSimple);
    }

    public void setXjcToStringMultiLine(boolean xjcToStringMultiLine) {
        this.model.setXjcToStringMultiLine(xjcToStringMultiLine);
    }

    public void setXjcLocator(boolean xjcLocator) {
        this.model.setXjcLocator(xjcLocator);
    }

    public void setXjcSyncMethods(boolean xjcSyncMethods) {
        this.model.setXjcSyncMethods(xjcSyncMethods);
    }

    public void setXjcMarkGenerated(boolean xjcMarkGenerated) {
        this.model.setXjcMarkGenerated(xjcMarkGenerated);
    }

    public void setIncludedNamespaces(Map value) {
        this.model.setIncludedNamespaces(value);
    }

    public void setBindingFiles(List<String> bindingFiles) {
        for (String path : bindingFiles) {
            this.model.getBindingFiles().add(path);
        }
    }
}

