/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.wizards.JavaProjectWizardPage;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.JptDbwsUiMessages;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;

public class BuilderXmlWizardPage
extends WizardPage {
    private final IStructuredSelection initialSelection;
    private IProject targetProject;
    protected SelectFileOrXMLCatalogIdPanel selectSourcePanel;
    protected static final String[] browseXMLFilterExtensions = new String[]{".xml"};

    public static IFile getBuilderXmlFromSelection(IStructuredSelection selection) {
        String elementExtension;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IFile && (elementExtension = ((IFile)firstElement).getFileExtension()) != null && browseXMLFilterExtensions[0].endsWith(elementExtension)) {
            return (IFile)firstElement;
        }
        return null;
    }

    BuilderXmlWizardPage(IStructuredSelection selection) {
        super("BuilderXmlWizardPage");
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        this.selectSourcePanel = new SelectFileOrXMLCatalogIdPanel(composite, this.initialSelection);
        this.selectSourcePanel.setLayoutData(new GridData(1808));
        SelectFileOrXMLCatalogIdPanel.PanelListener listener = new SelectFileOrXMLCatalogIdPanel.PanelListener(){

            public void completionStateChanged() {
                BuilderXmlWizardPage.this.selectFileOrXMLCatalogIdPanelChanged();
            }
        };
        this.selectSourcePanel.setListener(listener);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getBuilderXml() != null) {
                this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)this.getBuilderXml()));
            } else {
                this.updateTargetProject();
                IFile schema = BuilderXmlWizardPage.getBuilderXmlFromSelection(this.initialSelection);
                if (schema != null) {
                    this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)schema));
                } else {
                    this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)this.targetProject));
                }
            }
            this.selectSourcePanel.update();
            this.setTitle(JptDbwsUiMessages.BuilderXmlWizardPage_title);
            this.setDescription(JptDbwsUiMessages.BuilderXmlWizardPage_desc);
            this.selectSourcePanel.setFilterExtensions(browseXMLFilterExtensions);
        }
        this.selectSourcePanel.setVisibleHelper(visible);
    }

    public boolean isPageComplete() {
        return this.schemaOrUriSelected() && this.getErrorMessage() == null;
    }

    public IFile getBuilderXml() {
        return this.selectSourcePanel.getFile();
    }

    public String getSourceURI() {
        IFile file;
        String uri = this.selectSourcePanel.getXMLCatalogURI();
        if (uri == null && (file = this.selectSourcePanel.getFile()) != null) {
            uri = URIHelper.getPlatformURI((IResource)file);
        }
        return uri;
    }

    private void updateTargetProject() {
        IWizardPage previousPage = this.getPreviousPage();
        if (previousPage instanceof JavaProjectWizardPage) {
            this.targetProject = ((JavaProjectWizardPage)previousPage).getJavaProject().getProject();
        } else if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            this.targetProject = this.getProjectFromInitialSelection();
        }
    }

    private IProject getProjectFromInitialSelection() {
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IProject) {
            return (IProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            return ((IResource)firstElement).getProject();
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject().getProject();
        }
        return null;
    }

    private boolean schemaOrUriSelected() {
        return this.getBuilderXml() != null || this.getSourceURI() != null;
    }

    private String computeErrorMessage() {
        String errorMessage = null;
        String uri = this.getSourceURI();
        if (uri != null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
            errorMessage = JptDbwsUiMessages.BuilderXmlWizardPage_errorUriCannotBeLocated;
        }
        return errorMessage;
    }

    private void selectFileOrXMLCatalogIdPanelChanged() {
        String errorMessage = this.computeErrorMessage();
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.isPageComplete());
    }
}

