/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.launching.model.XSLLineBreakpoint;

public class XSLLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null) {
            IBreakpoint[] breakpoints;
            IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.xsl.launching.XSLDebugModel");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++n2;
            }
            XSLLineBreakpoint lineBreakpoint = new XSLLineBreakpoint(resource, lineNumber + 1, 1, 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        ITextEditor editorPart;
        IResource resource;
        if (part instanceof ITextEditor && (resource = (IResource)(editorPart = (ITextEditor)part).getEditorInput().getAdapter(IResource.class)) != null && resource.getType() == 1 && XSLCore.isXSLFile((IFile)((IFile)resource))) {
            return editorPart;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

