/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.serialize;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ws.commons.serialize.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLWriterImpl
implements XMLWriter {
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_IN_START_ELEMENT = 1;
    private static final int STATE_IN_ELEMENT = 2;
    private String encoding;
    private String indentString;
    private String lineFeed;
    private Writer w;
    private Locator l;
    private Map delayedPrefixes;
    int curIndent = 0;
    private int state;
    private boolean declarating;
    private boolean indenting;
    private boolean flushing;

    public void setEncoding(String pEncoding) {
        this.encoding = pEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDeclarating(boolean pDeclarating) {
        this.declarating = pDeclarating;
    }

    public boolean isDeclarating() {
        return this.declarating;
    }

    public void setIndenting(boolean pIndenting) {
        this.indenting = pIndenting;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setIndentString(String pIndentString) {
        this.indentString = pIndentString;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setLineFeed(String pLineFeed) {
        this.lineFeed = pLineFeed;
    }

    public String getLineFeed() {
        return this.lineFeed;
    }

    public void setFlushing(boolean pFlushing) {
        this.flushing = pFlushing;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void setWriter(Writer pWriter) {
        this.w = pWriter;
    }

    public Writer getWriter() {
        return this.w;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.l = pLocator;
    }

    public Locator getDocumentLocator() {
        return this.l;
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (this.delayedPrefixes == null) {
            this.delayedPrefixes = new HashMap();
        }
        if ("".equals(prefix)) {
            if (namespaceURI.equals(prefix)) {
                return;
            }
            prefix = "xmlns";
        } else {
            prefix = "xmlns:" + prefix;
        }
        this.delayedPrefixes.put(prefix, namespaceURI);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.delayedPrefixes != null) {
            prefix = "".equals(prefix) ? "xmlns" : "xmlns:" + prefix;
            this.delayedPrefixes.remove(prefix);
        }
    }

    public void startDocument() throws SAXException {
        if (this.delayedPrefixes != null) {
            this.delayedPrefixes.clear();
        }
        this.state = 0;
        this.curIndent = 0;
        if (this.isDeclarating() && this.w != null) {
            try {
                String lf;
                this.w.write("<?xml version=\"1.0\"");
                String enc = this.getEncoding();
                if (enc != null) {
                    this.w.write(" encoding=\"");
                    this.w.write(enc);
                    this.w.write("\"");
                }
                this.w.write("?>");
                if (this.isIndenting() && (lf = this.getLineFeed()) != null) {
                    this.w.write(lf);
                }
            }
            catch (IOException e) {
                throw new SAXException("Failed to write XML declaration: " + e.getMessage(), e);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.isFlushing() && this.w != null) {
            try {
                this.w.flush();
            }
            catch (IOException e) {
                throw new SAXException("Failed to flush target writer: " + e.getMessage(), e);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    private void stopTerminator() throws IOException {
        if (this.state == 1) {
            if (this.w != null) {
                this.w.write(62);
            }
            this.state = 2;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.stopTerminator();
            if (this.w == null) {
                return;
            }
            int end = start + length;
            block8: for (int i = start; i < end; ++i) {
                char c = ch[i];
                switch (c) {
                    case '&': {
                        this.w.write("&amp;");
                        continue block8;
                    }
                    case '<': {
                        this.w.write("&lt;");
                        continue block8;
                    }
                    case '>': {
                        this.w.write("&gt;");
                        continue block8;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        this.w.write(c);
                        continue block8;
                    }
                    default: {
                        if (this.canEncode(c)) {
                            this.w.write(c);
                            continue block8;
                        }
                        this.w.write("&#");
                        this.w.write(Integer.toString(c));
                        this.w.write(";");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public boolean canEncode(char c) {
        return c == '\n' || c >= ' ' && c < '\u007f';
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.isIndenting()) {
            --this.curIndent;
        }
        if (this.w != null) {
            try {
                if (this.state == 1) {
                    this.w.write("/>");
                    this.state = 0;
                } else {
                    if (this.state == 0) {
                        this.indentMe();
                    }
                    this.w.write("</");
                    this.w.write(qName);
                    this.w.write(62);
                }
                this.state = 0;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private void indentMe() throws IOException {
        if (this.w != null && this.isIndenting()) {
            String s = this.getLineFeed();
            if (s != null) {
                this.w.write(s);
            }
            if ((s = this.getIndentString()) != null) {
                for (int i = 0; i < this.curIndent; ++i) {
                    this.w.write(s);
                }
            }
        }
    }

    private void writeCData(String v) throws IOException {
        int len = v.length();
        block7: for (int j = 0; j < len; ++j) {
            char c = v.charAt(j);
            switch (c) {
                case '&': {
                    this.w.write("&amp;");
                    continue block7;
                }
                case '<': {
                    this.w.write("&lt;");
                    continue block7;
                }
                case '>': {
                    this.w.write("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.w.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.w.write("&quot;");
                    continue block7;
                }
                default: {
                    if (this.canEncode(c)) {
                        this.w.write(c);
                        continue block7;
                    }
                    this.w.write("&#");
                    this.w.write(Integer.toString(c));
                    this.w.write(59);
                }
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        try {
            this.stopTerminator();
            if (this.isIndenting()) {
                if (this.curIndent > 0) {
                    this.indentMe();
                }
                ++this.curIndent;
            }
            if (this.w != null) {
                this.w.write(60);
                this.w.write(qName);
                if (attr != null) {
                    int i = attr.getLength();
                    while (i > 0) {
                        this.w.write(32);
                        String name = attr.getQName(--i);
                        this.w.write(name);
                        if (this.delayedPrefixes != null) {
                            this.delayedPrefixes.remove(name);
                        }
                        this.w.write("=\"");
                        this.writeCData(attr.getValue(i));
                        this.w.write(34);
                    }
                }
                if (this.delayedPrefixes != null && this.delayedPrefixes.size() > 0) {
                    Iterator iter = this.delayedPrefixes.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        this.w.write(32);
                        this.w.write((String)entry.getKey());
                        this.w.write("=\"");
                        this.w.write((String)entry.getValue());
                        this.w.write(34);
                    }
                    this.delayedPrefixes.clear();
                }
            }
            this.state = 1;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void skippedEntity(String ent) throws SAXException {
        throw new SAXException("Don't know how to skip entities");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.stopTerminator();
            if (this.w != null) {
                this.w.write("<?");
                this.w.write(target);
                this.w.write(32);
                this.w.write(data);
                this.w.write("?>");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

