/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourcePersistentMember<M extends Member>
extends SourceAnnotatedElement<M>
implements JavaResourcePersistentMember {
    boolean persistable;
    boolean final_;

    SourcePersistentMember(JavaResourceNode parent, M member) {
        super(parent, member);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.persistable = this.buildPersistable(astRoot);
        IBinding binding = ((Member)this.annotatedElement).getBinding(astRoot);
        this.final_ = this.buildFinal(binding);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncPersistable(this.buildPersistable(astRoot));
        IBinding binding = ((Member)this.annotatedElement).getBinding(astRoot);
        this.syncFinal(this.buildFinal(binding));
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        HashSet annotationNames = CollectionTools.set(supportingAnnotationNames);
        if (primaryAnnotationName != null) {
            annotationNames.add(primaryAnnotationName);
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (annotationNames.contains(annotation.getAnnotationName())) continue;
            this.annotations.remove(annotation);
            annotation.removeAnnotation();
        }
        Annotation newPrimaryAnnotation = null;
        if (primaryAnnotationName != null && this.getAnnotation(primaryAnnotationName) == null) {
            newPrimaryAnnotation = this.buildAnnotation(primaryAnnotationName);
            this.annotations.add(newPrimaryAnnotation);
            newPrimaryAnnotation.newAnnotation();
        }
        return newPrimaryAnnotation;
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void syncPersistable(boolean astPersistable) {
        boolean old = this.persistable;
        this.persistable = astPersistable;
        this.firePropertyChanged("persistable", old, astPersistable);
    }

    private boolean buildPersistable(CompilationUnit astRoot) {
        return ((Member)this.annotatedElement).isPersistable(astRoot);
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void syncFinal(boolean astFinal) {
        boolean old = this.final_;
        this.final_ = astFinal;
        this.firePropertyChanged("final", old, astFinal);
    }

    private boolean buildFinal(IBinding binding) {
        return binding == null ? false : Modifier.isFinal((int)binding.getModifiers());
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return ((Member)this.annotatedElement).matches(memberName, occurrence);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        this.syncPersistable(this.buildPersistable(astRoot));
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        Filter filter = PERSISTABLE_MEMBER_FILTER;
        return new FilteringIterator(members, filter);
    }
}

