/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullAttributeOverrideColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAttributeOverrideAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceAttributeOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAttributeOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverride");
    private ElementAnnotationAdapter columnAdapter = this.buildColumnAdapter();
    private ColumnAnnotation column;
    private final ColumnAnnotation nullColumn = this.buildNullColumn();

    public SourceAttributeOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceColumnAnnotation.createAttributeOverrideColumn(this, (Member)this.annotatedElement, this.daa);
            this.column.initialize(astRoot);
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    public ColumnAnnotation getColumn() {
        return this.column;
    }

    @Override
    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : this.nullColumn;
    }

    @Override
    public ColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = SourceColumnAnnotation.createAttributeOverrideColumn(this, (Member)this.annotatedElement, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    @Override
    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        ColumnAnnotation old = this.column;
        this.column = null;
        old.removeAnnotation();
    }

    private void syncColumn(CompilationUnit astRoot) {
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            ColumnAnnotation col = SourceColumnAnnotation.createAttributeOverrideColumn(this, (Member)this.annotatedElement, this.daa);
            col.initialize(astRoot);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(astRoot);
        }
    }

    private void syncColumn_(ColumnAnnotation astColumn) {
        ColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    private ElementAnnotationAdapter buildColumnAdapter() {
        return new ElementAnnotationAdapter(this.annotatedElement, SourceColumnAnnotation.buildAttributeOverrideAnnotationAdapter(this.daa));
    }

    private ColumnAnnotation buildNullColumn() {
        return new NullAttributeOverrideColumnAnnotation(this);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.column == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.columnAdapter = this.buildColumnAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        if (this.column != null) {
            HashMap<String, Object> columnState = new HashMap<String, Object>();
            this.column.storeOn(columnState);
            map.put("column", columnState);
            this.column = null;
        }
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        Map columnState = (Map)map.get("column");
        if (columnState != null) {
            this.addColumn().restoreFrom(columnState);
        }
    }

    public static SourceAttributeOverrideAnnotation buildAttributeOverride(JavaResourceNode parent, Member member) {
        return new SourceAttributeOverrideAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceAttributeOverrideAnnotation buildNestedAttributeOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAttributeOverrideAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter, "javax.persistence.AttributeOverride");
        ElementIndexedAnnotationAdapter annotationAdapter = new ElementIndexedAnnotationAdapter((AnnotatedElement)member, idaa);
        return new SourceAttributeOverrideAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }
}

