/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableAssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableJoinColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAssociationOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAssociationOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverride");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();

    protected SourceAssociationOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.joinColumnsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        AnnotationContainerTools.synchronize(this.joinColumnsContainer, astRoot);
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    Iterable<NestableJoinColumnAnnotation> getNestableJoinColumns() {
        return new LiveCloneIterable(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    private NestableJoinColumnAnnotation addJoinColumn() {
        return this.addJoinColumn(this.joinColumns.size());
    }

    @Override
    public NestableJoinColumnAnnotation addJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation addJoinColumn_() {
        return this.addJoinColumn_(this.joinColumns.size());
    }

    private NestableJoinColumnAnnotation addJoinColumn_(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(index);
        this.joinColumns.add(index, joinColumn);
        return joinColumn;
    }

    void syncAddJoinColumn(Annotation astAnnotation) {
        int index = this.joinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addJoinColumn_(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createAssociationOverrideJoinColumn(this.daa, this, (Member)this.annotatedElement, index);
    }

    void joinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveJoinColumn_(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeJoinColumn_(int index) {
        return this.joinColumns.remove(index);
    }

    void syncRemoveJoinColumns(int index) {
        this.removeItemsFromList(index, this.joinColumns, "joinColumns");
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinColumns.isEmpty();
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        List<Map<String, Object>> joinColumnsState = this.buildStateList(this.joinColumns.size());
        for (NestableJoinColumnAnnotation joinColumn : this.getNestableJoinColumns()) {
            HashMap<String, Object> joinColumnState = new HashMap<String, Object>();
            joinColumn.storeOn(joinColumnState);
            joinColumnsState.add(joinColumnState);
        }
        map.put("joinColumns", joinColumnsState);
        this.joinColumns.clear();
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        List joinColumnsState = (List)map.get("joinColumns");
        for (Map joinColumnState : joinColumnsState) {
            this.addJoinColumn().restoreFrom(joinColumnState);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    implements AnnotationContainer<NestableJoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceAssociationOverrideAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        @Override
        public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
            return SourceAssociationOverrideAnnotation.this.getNestableJoinColumns();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceAssociationOverrideAnnotation.this.joinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotation() {
            return SourceAssociationOverrideAnnotation.this.addJoinColumn_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceAssociationOverrideAnnotation.this.syncAddJoinColumn(astAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceAssociationOverrideAnnotation.this.moveJoinColumn_(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
            return SourceAssociationOverrideAnnotation.this.removeJoinColumn_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceAssociationOverrideAnnotation.this.syncRemoveJoinColumns(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

