/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1;

import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaFile
extends AbstractJpaNode
implements JpaFile {
    protected final IFile file;
    protected final IContentType contentType;
    protected final JptResourceModel resourceModel;
    protected final Hashtable<Object, JpaStructureNode> rootStructureNodes = new Hashtable();

    public GenericJpaFile(JpaProject jpaProject, IFile file, IContentType contentType, JptResourceModel resourceModel) {
        super(jpaProject);
        this.file = file;
        this.contentType = contentType;
        this.resourceModel = resourceModel;
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("rootStructureNodes");
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public JptResourceModel getResourceModel() {
        return this.resourceModel;
    }

    @Override
    public JptResourceModel getResourceModel(IContentType ct) {
        return this.contentType.isKindOf(ct) ? this.resourceModel : null;
    }

    @Override
    public Iterable<JpaStructureNode> getRootStructureNodes() {
        return new LiveCloneIterable(this.rootStructureNodes.values());
    }

    @Override
    public int getRootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    @Override
    public void addRootStructureNode(Object key, JpaStructureNode rootStructureNode) {
        JpaStructureNode old = this.rootStructureNodes.put(key, rootStructureNode);
        if (rootStructureNode != old) {
            if (old != null) {
                this.fireItemRemoved("rootStructureNodes", old);
            }
            this.fireItemAdded("rootStructureNodes", rootStructureNode);
        }
    }

    @Override
    public void removeRootStructureNode(Object key, JpaStructureNode rootStructureNode) {
        if (Tools.valuesAreEqual((Object)rootStructureNode, (Object)this.rootStructureNodes.get(key))) {
            this.fireItemRemoved("rootStructureNodes", this.rootStructureNodes.remove(key));
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JpaStructureNode rootNode : this.getRootStructureNodes()) {
            JpaStructureNode node = rootNode.getStructureNode(textOffset);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.file);
        sb.append('[');
        sb.append(this.contentType.getName());
        sb.append(']');
    }
}

