/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContainerTools {
    public static <C extends JpaContextNode, R> void synchronizeWithResourceModel(Adapter<C, R> adapter) {
        ContextContainerTools.sync(adapter, true);
    }

    public static <C extends JpaContextNode, R> void update(Adapter<C, R> adapter) {
        ContextContainerTools.sync(adapter, false);
    }

    protected static <C extends JpaContextNode, R> void sync(Adapter<C, R> adapter, boolean sync) {
        HashSet contextElements = CollectionTools.set(adapter.getContextElements());
        ArrayList<JpaContextNode> contextElementsToSync = new ArrayList<JpaContextNode>(contextElements.size());
        int resourceIndex = 0;
        for (R resourceElement : adapter.getResourceElements()) {
            boolean match = false;
            Iterator stream = contextElements.iterator();
            while (stream.hasNext()) {
                JpaContextNode contextElement = (JpaContextNode)stream.next();
                if (!Tools.valuesAreEqual(adapter.getResourceElement(contextElement), resourceElement)) continue;
                adapter.moveContextElement(resourceIndex, contextElement);
                stream.remove();
                contextElementsToSync.add(contextElement);
                match = true;
                break;
            }
            if (!match) {
                adapter.addContextElement(resourceIndex, resourceElement);
            }
            ++resourceIndex;
        }
        for (JpaContextNode contextElement : contextElements) {
            adapter.removeContextElement(contextElement);
        }
        for (JpaContextNode contextElement : contextElementsToSync) {
            if (sync) {
                contextElement.synchronizeWithResourceModel();
                continue;
            }
            contextElement.update();
        }
    }

    private ContextContainerTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter<C extends JpaContextNode, R> {
        public Iterable<C> getContextElements();

        public Iterable<R> getResourceElements();

        public R getResourceElement(C var1);

        public void moveContextElement(int var1, C var2);

        public void addContextElement(int var1, R var2);

        public void removeContextElement(C var1);
    }
}

