/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.Comparator;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformFactory;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatformProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.GenericJpaFactory;
import org.eclipse.wst.common.project.facet.core.DefaultVersionComparator;

public class GenericJpaPlatformFactory
implements JpaPlatformFactory {
    public JpaPlatform buildJpaPlatform(String id) {
        return new GenericJpaPlatform(id, this.buildJpaVersion(), new GenericJpaFactory(), new GenericJpaAnnotationProvider(GenericJpaAnnotationDefinitionProvider.instance()), GenericJpaPlatformProvider.instance(), this.buildJpaPlatformVariation());
    }

    private JpaPlatform.Version buildJpaVersion() {
        return new SimpleVersion(JpaFacet.VERSION_1_0.getVersionString());
    }

    protected JpaPlatformVariation buildJpaPlatformVariation() {
        return new JpaPlatformVariation(){

            public JpaPlatformVariation.Supported getTablePerConcreteClassInheritanceIsSupported() {
                return JpaPlatformVariation.Supported.MAYBE;
            }

            public boolean isJoinTableOverridable() {
                return false;
            }
        };
    }

    public static class SimpleVersion
    implements JpaPlatform.Version {
        protected final String jpaVersion;
        public static final Comparator<String> JPA_VERSION_COMPARATOR = new DefaultVersionComparator();

        public SimpleVersion(String jpaVersion) {
            this.jpaVersion = jpaVersion;
        }

        public String getVersion() {
            return this.getJpaVersion();
        }

        public String getJpaVersion() {
            return this.jpaVersion;
        }

        public boolean isCompatibleWithJpaVersion(String version) {
            return JPA_VERSION_COMPARATOR.compare(this.jpaVersion, version) >= 0;
        }

        public String toString() {
            return "JPA version: " + this.getJpaVersion();
        }
    }
}

