/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugHistory {
    private final int bugId;
    private final List<Revision> revisions;

    public BugHistory(int bugId) {
        this.bugId = bugId;
        this.revisions = new ArrayList<Revision>();
    }

    public Revision createRevision(Date when, String who) {
        Revision revision = new Revision(when, who);
        this.revisions.add(revision);
        return revision;
    }

    public int getBugId() {
        return this.bugId;
    }

    public List<Revision> getRevisions() {
        return this.revisions;
    }

    public static class Change {
        private final String added;
        private final int attachmentId;
        private final String fieldName;
        private final String removed;

        private Change(String fieldName, String added, String removed, int attachmentId) {
            this.fieldName = fieldName;
            this.added = added;
            this.removed = removed;
            this.attachmentId = attachmentId;
        }

        public String getAdded() {
            return this.added;
        }

        public int getAttachmentId() {
            return this.attachmentId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getRemoved() {
            return this.removed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Revision {
        private final List<Change> changes;
        private final Date when;
        private final String who;

        private Revision(Date when, String who) {
            this.when = when;
            this.who = who;
            this.changes = new ArrayList<Change>();
        }

        public void addChange(String fieldName, String added, String removed, int attachmentId) {
            this.changes.add(new Change(fieldName, added, removed, attachmentId));
        }

        public List<Change> getChanges() {
            return this.changes;
        }

        public Date getWhen() {
            return this.when;
        }

        public String getWho() {
            return this.who;
        }
    }
}

