/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.xsl.ui.internal.style.AbstractXSLSemanticHighlighting;

public class XSLTagDelimsSemanticHighlighting
extends AbstractXSLSemanticHighlighting
implements ISemanticHighlighting {
    public String getStylePreferenceKey() {
        return "xsltagBorder";
    }

    public String getEnabledPreferenceKey() {
        return "xsl.ui.highlighting.tag.enabled";
    }

    public Position[] consumes(IStructuredDocumentRegion region) {
        List openPos = this.createSemanticPositions(region.getFirstRegion(), region, "XML_TAG_OPEN");
        List endOpenPos = this.createSemanticPositions(region.getFirstRegion(), region, "XML_END_TAG_OPEN");
        List emptyTagClose = this.createSemanticPositions(region, "XML_EMPTY_TAG_CLOSE");
        List closePos = this.createSemanticPositions(region, "XML_TAG_CLOSE");
        ArrayList arrpos = new ArrayList();
        arrpos.addAll(openPos);
        arrpos.addAll(closePos);
        arrpos.addAll(endOpenPos);
        arrpos.addAll(emptyTagClose);
        Position[] allPos = new Position[arrpos.size()];
        if (!arrpos.isEmpty()) {
            arrpos.toArray(allPos);
        }
        return allPos;
    }

    protected List createSemanticPositions(ITextRegion textRegion, IStructuredDocumentRegion region, String regionType) {
        ArrayList<Position> arrpos = new ArrayList<Position>();
        if (textRegion == null) {
            return Collections.EMPTY_LIST;
        }
        if (regionType.equals(textRegion.getType())) {
            Position pos = new Position(region.getStartOffset(textRegion), textRegion.getLength());
            arrpos.add(pos);
        }
        return arrpos;
    }
}

